#!/bin/sh

. ./_blfsset.sh

APPNAME=libatomic_ops
VER=7.6.6
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#sed -i 's#pkgdata#doc#' doc/Makefile.am

#echo Autoreconfing...
#autoreconf -fi \
#	1> $LOG/$TARGET.1_auto.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr \
            --enable-shared  \
            --disable-static \
            --docdir=/usr/share/doc/libatomic_ops-$VER \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1
#porg -lp+ $TARGET "\
#mv -v   /usr/share/libatomic_ops/* \
#        /usr/share/doc/libatomic_ops-$VER" \
#	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
#porg -lp+ $TARGET "\
#rm -vrf /usr/share/libatomic_ops" \
#	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

