#!/bin/sh

VER=3.5.13
TARGET=arts-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

. ../_blfsset.sh
. ./_kde3set.sh

echo Check Required...
../_checkRequired.sh alsa-lib audiofile cmake libmad \
	libvorbis pkg-config qt-3 || exit 1

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

echo \ \ Cmaking...
BUILD=/tmp/buildarts
ARTS=`pwd`
rm -rf   $BUILD
mkdir -p $BUILD
cd       $BUILD

cmake $ARTS                              \
  -DCMAKE_INSTALL_PREFIX=$TRINITY_PREFIX \
  -DCMAKE_VERBOSE_MAKEFILE=ON
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

unset ARTS BUILD

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET 'make install' \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo -n \ \ Pacoing:\   && paco -a1 | grep $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

