#!/bin/sh

. ../_blfsset.sh
. ./_gnomeset.sh

APPNAME=gdm
VER=3.6.2
TARGET=$APPNAME-$VER
TARGETBALL=$GNOMEDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	accountsservice dconf gtk+-3 \
        libcanberra Linux-PAM nss \
        gnome-session metacity
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

groupadd -g 21 gdm 
useradd -c "GDM Daemon Owner" -d /var/lib/gdm -u 21 \
        -g gdm -s /bin/false gdm
usermod -a -G audio gdm
usermod -a -G video gdm

#echo \ \ Patching...
#patch -Np1 -i $GNOMEDLD/gdm-$VER-vt-allocation-hack-1.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1
#patch -Np1 -i $GNOMEDLD/gdm-$VER-blfs-patch-1.patch
#	1>> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr \
            --sysconfdir=/etc \
            --localstatedir=/var \
            --libexecdir=/usr/lib/gdm \
            --with-initial-vt=7 \
            --with-at-spi-registryd-directory=/usr/lib/at-spi2-core \
            --with-authentication-agent-directory=/usr/lib/polkit-gnome \
            --with-check-accelerated-directory=/usr/lib/gnome-session \
            --with-consolekit-directory=/usr/lib/ConsoleKit \
            --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1
chown -R -v gdm:gdm /var/lib/gdm /var/cache/gdm /var/log/gdm

echo From CBLFS...
install -v -m755 -d /var/log/gdm
sed -i.orig "/\[daemon\]/ a LogDir=/var/log/gdm" \
    /etc/gdm/custom.conf

sed -i "/\[gui\]/ a GtkTheme=Clearlooks" \
    /etc/gdm/custom.conf

cat > /etc/pam.d/gdm << "EOF" &&
#%PAM-1.0

auth       include      system-auth
account    include      system-auth
password   include      system-auth
session    include      system-auth
EOF
paco -p+ $TARGET "touch /etc/pam.d/gdm"

cp /etc/pam.d/gdm{,-autologin}
echo "auth       required     pam_permit.so" >> /etc/pam.d/gdm-autologin
paco -p+ $TARGET "touch /etc/pam.d/gdm-autologin"


TimeEnd

cd ..
RemoveSrcDir
PacoingDone

