#!/bin/sh

. ../_blfsset.sh
. ./_xorgset.sh

APPNAME=xf86-video-intel
VER=20170216
TARGET=$APPNAME-$VER
TARGETBALL=$XORGDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	xcb-util xorg-server
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure $XORG_CONFIG      \
            --enable-kms-only \
            --enable-uxa      \
            --enable-glamor   \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
mv -v /usr/share/man/man4/intel-virtual-output.4 \
      /usr/share/man/man1/intel-virtual-output.1" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
sed -i '/\.TH/s/4/1/' /usr/share/man/man1/intel-virtual-output.1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

