#!/bin/sh

. ../_blfsset.sh
. ./_xorgset.sh

APPNAME=mesa
VER=18.1.6
TARGET=$APPNAME-$VER
TARGETBALL=$XORGDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	Xorg-lib-libX11 libdrm python-2 llvm
. $WRK/_checkOptions.sh  \
	llvm elfutils libvdpau \
	lesstif wayland-protocols
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

if [ ${OPTION_llvm} -eq "1" ]; then
  export ENABLELLVM="--enable-gallium-llvm "
  export GLL_DRV="nouveau,r300,r600,radeonsi,svga,swrast"
else
  export ENABLELLVM=""
  export GLL_DRV="nouveau,r600,svga,swrast"
fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#Patching
#patch -Np1 -i $XORGDLD/mesa-$VER-add_xdemos-1.patch \
#	1>  $LOG/$TARGET.0_patch.log 2>&1 || exit 1

#sed -i "/pthread_stubs_possible=/s/yes/no/" configure.ac

Configuring
./configure CFLAGS='-O2' CXXFLAGS='-O2' LDFLAGS=-lLLVM \
            --prefix=$XORG_PREFIX              \
            --sysconfdir=/etc                  \
            --enable-texture-float             \
            --enable-osmesa                    \
            --enable-xa                        \
            --enable-glx-tls                   \
            --with-platforms="drm,x11,wayland" \
            --with-gallium-drivers=$GLL_DRV    \
	    $ENABLELLVM \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

unset GLL_DRV

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || \
	(echo Failed to install && exit 1)

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

