#!/bin/sh

. ../_blfsset.sh
. ./_xorgset.sh

APPNAME=gdk-pixbuf
VER=2.36.12
TARGET=$APPNAME-$VER
TARGETBALL=$XORGDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	glib-2 libjpeg-turbo libpng libtiff shared-mime-info
. $WRK/_checkOptions.sh Xorg-lib-libX11 \
	jasper gobject-introspection gtk-doc
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
	$([ ${OPTION_XorgliblibX11} -eq "1" ] && echo --with-x11) \
	$([ ${OPTION_jasper} -eq "1" ] && echo --with-libjasper) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone
