#!/bin/sh

. ./_blfsset.sh

APPNAME=NetworkManager
VER=0.9.8.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	dbus-glib intltool libnl \
        nss udev iptables
. $WRK/_checkOptions.sh  \
	consolekit dhcpcd gobject-introspection \
	libsoup polkit upower vala \
        gtk-doc ModemManager wpa_supplicant
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#echo Patching unofficial...
#patch -Np1 -i $WRK/patch/NetworkManager-$VER.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr \
            --sysconfdir=/etc \
            --localstatedir=/var \
            --libexecdir=/usr/lib/NetworkManager \
            --without-systemdsystemunitdir \
	    --disable-ppp \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

cat >> /etc/NetworkManager/NetworkManager.conf << "EOF"
[main]
plugins=keyfile
EOF

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

