#!/bin/sh

CHAP=8
APPNAME=systemd
VER=245
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/systemd-$VER-gcc_10-fixes-2.patch \
	1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

ln -sf /bin/true /usr/bin/xsltproc

echo \ \ Extract manpage tarball...
tar -xf $DLD/systemd-man-pages-$VER.tar.xz || \
  (echo Not found manpage tarball && exit 1)

sed '179,$ d' -i src/resolve/meson.build

sed -i 's/GROUP="render", //' rules.d/50-udev-default.rules.in

mkdir -p build
cd       build

echo \ \ Configuring...
LANG=en_US.UTF-8                    \
meson --prefix=/usr                 \
      --sysconfdir=/etc             \
      --localstatedir=/var          \
      -Dblkid=true                  \
      -Dbuildtype=release           \
      -Ddefault-dnssec=no           \
      -Dfirstboot=false             \
      -Dinstall-tests=false         \
      -Dkmod-path=/bin/kmod         \
      -Dldconfig=false              \
      -Dmount-path=/bin/mount       \
      -Drootprefix=                 \
      -Drootlibdir=/lib             \
      -Dsplit-usr=true              \
      -Dsulogin-path=/sbin/sulogin  \
      -Dsysusers=false              \
      -Dumount-path=/bin/umount     \
      -Db_lto=false                 \
      -Drpmmacrosdir=no             \
      -Dhomed=false                 \
      -Duserdb=false                \
      -Dman=true                    \
      ..                            \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
LANG=en_US.UTF-8 ninja \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
PWD=`pwd`
porg -lp $TARGET -E$PWD "\
LANG=en_US.UTF-8 ninja install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

rm -f /usr/bin/xsltproc

porg -lp+ $TARGET "\
systemd-machine-id-setup && \
systemctl preset-all" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
systemctl disable systemd-time-wait-sync.service" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
rm -f /etc/sysctl.d/50-pid-max.conf" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap8

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd ../..
rm -fr $TARGETDIR

echo \ \ Done.
