#!/bin/sh

CHAP=8
APPNAME=iana-etc
VER=20200429
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Installing...
porg -lp $TARGET "\
cp services protocols /etc" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap8

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Done.
