#!/bin/sh

CHAP=8
APPNAME=gcc
VER=10.1.0
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

TimeStart

case $(uname -m) in
  x86_64)
    sed -e '/m64=/s/lib64/lib/' \
        -i.orig gcc/config/i386/t-linux64
  ;;
esac

mkdir build
cd    build

echo \ \ Configuring...
SED=sed                               \
../configure --prefix=/usr            \
             --enable-languages=c,c++ \
             --disable-multilib       \
             --disable-bootstrap      \
             --with-system-zlib       \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
porg -lp $TARGET -E`pwd` "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
rm -rf /usr/lib/gcc/$(gcc -dumpmachine)/$VER/include-fixed/bits/" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
ln -sfv ../usr/bin/cpp /lib" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
install -v -dm755 /usr/lib/bfd-plugins" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
ln -sfv ../../libexec/gcc/$(gcc -dumpmachine)/$VER/liblto_plugin.so \
        /usr/lib/bfd-plugins/" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

echo 'int main(){}' > dummy.c
cc dummy.c -v -Wl,--verbose &> dummy.log
readelf -l a.out | grep ': /lib'

grep -o '/usr/lib.*/crt[1in].*succeeded' dummy.log

grep -B4 '^ /usr/include' dummy.log

grep 'SEARCH.*/usr/lib' dummy.log |sed 's|; |\n|g'

grep "/lib.*/libc.so.6 " dummy.log

grep found dummy.log

rm -v dummy.c a.out dummy.log

#case `uname -m` in
#  i?86) GDBDIR=/usr/share/gdb/auto-load/usr/lib/   ;;
#  *)    GDBDIR=/usr/share/gdb/auto-load/usr/lib64/ ;;
#esac

#mkdir -pv $GDBDIR
#paco -p+ $TARGET "\
#mv -v /usr/lib/*gdb.py $GDBDIR" \
#	1>> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1
#unset GDBDIR

mkdir -p /usr/share/gdb/auto-load/usr/lib
porg -lp+ $TARGET "\
mv -v /usr/lib/*gdb.py /usr/share/gdb/auto-load/usr/lib" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap8

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd ../..
rm -fr $TARGETDIR

echo \ \ Done.
