#!/bin/sh

CHAP=6

. ./_lfsset.sh

APPNAME=linux
TARGET=$APPNAME-$LINUX_VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

TimeStart

echo \ \ Making mrproper...
make mrproper \
	1> $LOG/$CHAP.$TARGET.1_mrproper.log 2>&1 || exit 1

echo \ \ Installing...
make headers \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

find usr/include -name '.*' -delete &&
rm usr/include/Makefile \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

porg -lp linux-headers-$LINUX_VER -E`pwd` "\
cp -rv usr/include/* /usr/include" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap6

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
