#!/bin/sh

CHAP=6
APPNAME=binutils
APPVER=.2
VER=2.34
TARGET=$APPNAME-$VER
TARGETBALL=${TARGET}.tar.xz
TARGETDIR=$TARGET

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

mkdir build
cd    build

echo \ \ Configuring...
../configure                   \
    --prefix=/usr              \
    --build=$(../config.guess) \
    --host=$LFS_TGT            \
    --disable-nls              \
    --enable-shared            \
    --disable-werror           \
    --enable-64-bit-bfd        \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1

echo \ \ Installing...
make DESTDIR=$LFS install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1

TimeEnd chap6

echo \ \ Removing directory...
cd ../..
rm -fr $TARGETDIR

echo \ \ Done.
