#!/bin/sh

CHAP=6
APPNAME=bash
VER=5.0
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=/usr                   \
            --build=$(support/config.guess) \
            --host=$LFS_TGT                 \
            --without-bash-malloc           \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
make DESTDIR=$LFS install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
mv $LFS/usr/bin/bash $LFS/bin/bash \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
ln -sv bash $LFS/bin/sh \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap6

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
