#!/bin/sh

CHAP=10

. ./_lfsset.sh

APPNAME=linux
APPVER=.c10
VER=$LINUX_VER
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

TimeStart

echo \ \ Making mrproper...
make mrproper \
	1> $LOG/$CHAP.$TARGET.1_mrproper.log 2>&1

#sed -e '/cpu_startup/a asm("");' \
#    -i arch/x86/{kernel/smpboot.c,xen/smp_pv.c}

make menuconfig 

make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

porg -lp $TARGET "make modules_install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
cp -v arch/x86/boot/bzImage /boot/vmlinuz-$VER-lfs-$SYSDVER-systemd"

porg -lp+ $TARGET "\
cp -v System.map /boot/System.map-$VER"

porg -lp+ $TARGET "\
cp -v .config /boot/config-$VER"

install -d /usr/share/doc/linux-$VER

porg -lp+ $TARGET "\
cp -r Documentation/* /usr/share/doc/linux-$VER"

cat > /etc/modprobe.conf << "EOF"
# Begin /etc/modprobe.conf

install ohci_hcd /sbin/modprobe ehci_hcd ; /sbin/modprobe -i ohci_hcd ; true
install uhci_hcd /sbin/modprobe ehci_hcd ; /sbin/modprobe -i uhci_hcd ; true

# End /etc/modprobe.conf
EOF
porg -lp+ $TARGET "touch /etc/modprobe.conf"

TimeEnd chap10

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
