#/bin/sh

. ./_clfsset.sh

APPNAME=zlib
VER=1.2.8
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
CC="gcc -isystem /usr/include ${BUILD64}" \
CXX="g++ -isystem /usr/include ${BUILD64}" \
LDFLAGS="-Wl,-rpath-link,/usr/lib64:/lib64 ${BUILD64}" \
  ./configure --prefix=/usr --libdir=/usr/lib64 \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
mv -v /usr/lib64/libz.so.* /lib64 \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
ln -sfv ../../lib64/$(readlink /usr/lib64/libz.so) /usr/lib64/libz.so \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
mkdir -pv /usr/share/doc/zlib-1.2.8 \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
cp -rv doc/* examples /usr/share/doc/zlib-1.2.8 \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.
