#!/bin/sh

. ./_blfsset.sh

APPNAME=systemd
VER=239
TARGET=$APPNAME-$VER
LFSDLD=$LFS/download/LFS
TARGETBALL=$LFSDLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	Linux-PAM
. $WRK/_checkOptions.sh  \
	polkit
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
patch -Np1 -i $DLD/systemd-$VER-glibc_statx_fix-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

sed -i 's/GROUP="render", //' rules/50-udev-default.rules.in

mkdir build
cd    build

Configuring
meson --prefix=/usr         \
      --sysconfdir=/etc     \
      --localstatedir=/var  \
      -Dblkid=true          \
      -Dbuildtype=release   \
      -Ddefault-dnssec=no   \
      -Dfirstboot=false     \
      -Dinstall-tests=false \
      -Dldconfig=false      \
      -Drootprefix=         \
      -Drootlibdir=/lib     \
      -Dsplit-usr=true      \
      -Dsysusers=false      \
      -Db_lto=false         \
      .. \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
ninja -j1 \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "ninja install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
rm -rfv /usr/lib/rpm" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PorgingDone

cat >> /etc/pam.d/system-session << "EOF"
# Begin Systemd addition
    
session   required    pam_loginuid.so
session   optional    pam_systemd.so

# End Systemd addition
EOF
porg -lp+ $TARGET "touch /etc/pam.d/system-session"

cat > /etc/pam.d/systemd-user << "EOF"
# Begin /etc/pam.d/systemd-user

account  required pam_access.so
account  include  system-account

session  required pam_env.so
session  required pam_limits.so
session  include  system-session

auth     required pam_deny.so
password required pam_deny.so

# End /etc/pam.d/systemd-user
EOF
porg -lp+ $TARGET "touch /etc/pam.d/system-user"

systemctl daemon-reload
systemctl start multi-user.target

