#!/bin/sh

. ./_blfsset.sh

APPNAME=openobex
VER=1.7.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET-Source.tar.gz
TARGETDIR=$TARGET-Source

echo $TARGET

. $WRK/_checkRequired.sh \
	cmake libusb
. $WRK/_checkOptions.sh  \
	bluez doxygen libxslt openjdk xmlto
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

mkdir build
cd    build

echo Cmaking...
cmake -DCMAKE_INSTALL_PREFIX=/usr \
      -DCMAKE_INSTALL_LIBDIR=lib  \
      -DCMAKE_BUILD_TYPE=Release  \
      .. \
	1> $LOG/$TARGET.1_cmake.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PacoingDone

