#!/bin/sh

. ./_blfsset.sh

APPNAME=openafs
VER=1.7.28
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET-src.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

echo
echo Cannot build yet. && exit 1
echo

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#	--with-afs-sysname=i386_linux26 \

Configuring
XCFLAGS= \
./configure --prefix=/usr \
	--with-afs-sysname=ia64_linux26 \
	--enable-transarc-paths \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
XCFLAGS= \
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

