#!/bin/sh

. ./_blfsset.sh

APPNAME=libyaml
VER=0.2.4
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$APPNAME-dist-$VER.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	doxygen
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo Bootstrapping...
./bootstrap \
	1> $LOG/$TARGET.0_boot.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

