#!/bin/sh

. ./_blfsset.sh

APPNAME=libuv
VER=1.40.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$APPNAME-v$VER.tar.gz
TARGETDIR=$APPNAME-v$VER

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo Autogen...
sh autogen.sh \
	1> $LOG/$TARGET.0_auto.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

PWD=`pwd`
Installing
porg -lp $TARGET -E$PWD "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

