#!/bin/sh

. ./_blfsset.sh

APPNAME=libtirpc
VER=1.2.6
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	krb5
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr     \
            --sysconfdir=/etc \
            --disable-static  \
            --disable-gssapi  \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
mv -v /usr/lib/libtirpc.so.* /lib" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
ln -sfv ../../lib/libtirpc.so.3.0.0 /usr/lib/libtirpc.so" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

