#!/bin/sh

. ./_blfsset.sh
. ./Xorg/_xorgset.sh

APPNAME=libdrm
VER=2.4.100
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	Xorg-lib-libX11 \
	docbook-xml docbook-xsl libxslt valgrind
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

mkdir build
cd    build

Configuring
meson --prefix=/usr \
	-Dudev=true \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
ninja \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

PWD=`pwd`
Installing
porg -lp $TARGET -E$PWD "ninja install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PorgingDone
