#!/bin/sh

. ./_blfsset.sh

APPNAME=gnutls
VER=3.6.15
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$APPNAME-$VER

echo $TARGET

. $WRK/_checkRequired.sh \
	nettle libunistring libtasn1 p11-kit
. $WRK/_checkOptions.sh  \
	cacerts gtk-doc guile libidn \
        autogen trousers unbound valgrind
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

#if [ ${OPTION_p11kit} -eq "1" ]; then
#  export WITHP11KIT=""
#  export DEFAULTSTORE="--with-default-trust-store-pkcs11=\"pkcs11:\" "
#else
#  export WITHP11KIT="--without-p11-kit "
#  export DEFAULTSTORE="--with-default-trust-store-file=/etc/ssl/ca-bundle.crt"
#fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#	$WITHP11KIT \
#	$DEFAULTSTORE \
Configuring
./configure --prefix=/usr \
	--docdir=/usr/share/doc/gnutls-$VER \
	--disable-guile \
	--with-default-trust-store-pkcs11="pkcs11:" \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make -j1 \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone
