#!/bin/sh

. ./_blfsset.sh

APPNAME=emacs
VER=26.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	giflib Xorg-lib-libX11 gnutls \
        libjpeg-turbo libpng tiff libungif
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
            --libexecdir=/usr/lib \
            --localstatedir=/var \
$([ ${OPTION_gnutls} -ne 1 ] && echo --with-gnutls=no) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo Bootstrapping...
make bootstrap \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

chown -v -R root:root /usr/share/emacs/$VER \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

