#!/bin/sh

. ../_blfsset.sh
. ./_xorgset.sh

APPNAME=gdk-pixbuf
VER=2.38.0
TARGET=$APPNAME-$VER
TARGETBALL=$XORGDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	glib-2 libjpeg-turbo libpng shared-mime-info
. $WRK/_checkOptions.sh Xorg-lib-libX11 \
	libtiff \
	jasper gobject-introspection gtk-doc
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

mkdir build
cd    build


Configuring
meson --prefix=/usr .. \
$([ ${OPTION_jasper} -eq "1" ] && echo -Djasper=true) \
$([ ${OPTION_XorgliblibX11} -ne "1" ] && echo -Dx11=false) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
ninja \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp  $TARGET -E`pwd` "ninja install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PorgingDone
