//
//  Ship.h
//  KanColleLevelManager
//
//  Created by Hori,Masaki on 2013/11/10.
//  Copyright (c) 2013年 Hori,Masaki. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreData/CoreData.h>

@class CollectedShip;

@interface Ship : NSManagedObject

@property (nonatomic, retain) id imageURL;
@property (nonatomic, retain) NSString * name;
@property (nonatomic, retain) NSNumber * number;
@property (nonatomic, retain) id smallImageURL;
@property (nonatomic, retain) NSNumber * updateLevel;
@property (nonatomic, retain) NSNumber * updateNumber;
@property (readonly) NSNumber * tranceformedNumber;
@property (nonatomic, retain) NSSet *collection;
@property (nonatomic, retain) NSManagedObject *type;
@end

@interface Ship (CoreDataGeneratedAccessors)

- (void)addCollectionObject:(CollectedShip *)value;
- (void)removeCollectionObject:(CollectedShip *)value;
- (void)addCollection:(NSSet *)values;
- (void)removeCollection:(NSSet *)values;

@end
