//
//  KCBattleWindowController.m
//  KanColleLevelManager
//
//  Created by Hori,Masaki on 2013/10/26.
//  Copyright (c) 2013年 Hori,Masaki. All rights reserved.
//

#import "KCBattleWindowController.h"

#import "HMAppDelegate.h"


#import "KCFleetViewController.h"

#import "KCBattleViewController.h"
#import "KCManueversViewController.h"



@interface KCBattleWindowController ()
@property (retain) KCFleetViewController *fleetViewController;

@property (retain) KCBattleViewController *battleViewController;
@property (retain) KCManueversViewController *manueverViewController;
@property (retain) KCManueversViewController *undefinedViewController;

@property (retain) NSObjectController *selectedController;

@property NSInteger prevSelectedWinTag;

@end

@interface KCBattleWindowController (KC_NSTabViewDelegate) <NSTabViewDelegate>
@end


@implementation KCBattleWindowController

- (id)init
{
    self = [super initWithWindowNibName:NSStringFromClass([self class])];
    if (self) {
        // Initialization code here.
    }
    return self;
}

- (void)windowDidLoad
{
    [super windowDidLoad];
	
	self.fleetViewController = [KCFleetViewController new];
	
	NSView *view = self.fleetViewPlaceholder;
	self.fleetViewController.view.frame = view.frame;
	[[view superview] replaceSubview:view with:self.fleetViewController.view];
	
	//
	self.battleViewController = [KCBattleViewController new];
	NSTabViewItem *item = [self.fieldTabView tabViewItemAtIndex:0];
	[item setView:self.battleViewController.view];
	
	self.selectedController = self.battleViewController.controller;
	
	
	//
	self.manueverViewController = [KCManueversViewController new];
	item = [self.fieldTabView tabViewItemAtIndex:1];
	[item setView:self.manueverViewController.view];
	
	
	//
	self.undefinedViewController = [KCManueversViewController new];
	item = [self.fieldTabView tabViewItemAtIndex:3];
	[item setView:self.undefinedViewController.view];
}

- (NSUndoManager *)windowWillReturnUndoManager:(NSWindow *)window
{
	return self.managedObjectContext.undoManager;
}


- (NSManagedObjectContext *)managedObjectContext
{
	return ((HMAppDelegate *)[NSApp delegate]).managedObjectContext;
}

- (IBAction)calculate:(id)sender
{
	// 経験値倍率
	// 旗艦 1.5
	// MVP 2.0
	
	// 戦績倍率
	// S 1.2
	// A 1.0
	// B 1.0
	// C 0.8
	// D 0.7
	// E 0.5 MVPなし
	
	// 海域EXP取得
	double areaExp = [[self.selectedController valueForKeyPath:@"selection.areaExp"] integerValue];
	
	// 戦績倍率
	NSInteger winTag = [[self.winRadio selectedCell] tag];
	switch(winTag) {
		case 1:
			areaExp *= 1.2;
			break;
		case 2:
		case 3:
			break;
		case 4:
			areaExp *= 0.8;
			break;
		case 5:
			areaExp *= 0.7;
			break;
		case 6:
			areaExp *= 0.5;
			break;
	}
	
	// 旗艦、MVP倍率
	NSInteger mvpTag = [[self.mvpRaio selectedCell] tag];
	
	// 艦隊取得
	NSNumber *fleetNumber = [self.fleetViewController fleetNumber];
	NSFetchRequest *req = [NSFetchRequest fetchRequestWithEntityName:@"CollectedShip"];
	NSSortDescriptor *sortDesc = [NSSortDescriptor sortDescriptorWithKey:@"fleetOrder" ascending:YES];
	NSPredicate	*predicate = [NSPredicate predicateWithFormat:@"fleetNumber = %@", fleetNumber];
	[req setSortDescriptors:@[sortDesc]];
	[req setPredicate:predicate];
	
	NSArray *fleetShips = [self.managedObjectContext executeFetchRequest:req
																   error:NULL];
	
	// 追加
	NSInteger index = 1;
	for(id ship in fleetShips) {
		double exp = areaExp;
		if(index == 1) {
			exp *= 1.5;
		}
		if(index == mvpTag && winTag != 6) {
			exp *= 2.0;
		}
//		NSLog(@"exp -> %lf", exp);
		NSInteger shipExp = [[ship valueForKey:@"exp"] integerValue];
		exp += shipExp;
		[ship setValue:@((int)exp) forKey:@"exp"];
		
		index++;
	}
}

- (void)setManueverMode:(BOOL)flag
{
	if(flag) {
		self.prevSelectedWinTag = [[self.winRadio selectedCell] tag];
		[self.winRadio selectCellWithTag:2];
		[self.winRadio setEnabled:NO];
	} else {
		[self.winRadio setEnabled:YES];
		[self.winRadio selectCellWithTag:self.prevSelectedWinTag];
	}
}

- (void)tabView:(NSTabView *)tabView didSelectTabViewItem:(NSTabViewItem *)tabViewItem
{
	NSString *identifier = [tabViewItem identifier];
	if([identifier isEqualToString:@"battle"]) {
		self.selectedController = self.battleViewController.controller;
		[self setManueverMode:NO];
	} else if([identifier isEqualToString:@"manuever"]) {
		self.selectedController = self.manueverViewController.controller;
		[self setManueverMode:YES];
	} else if([identifier isEqualToString:@"undefined"]) {
		self.selectedController = self.undefinedViewController.controller;
		[self setManueverMode:NO];
	} else {
		[self setManueverMode:NO];
	}
}

@end
