//
//  BSMessageSampleRegistrant.h
//  BathyScaphe
//
//  Created by Tsutomu Sawada on 10/04/11.
//  Copyright 2010 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import <Cocoa/Cocoa.h>


@class CMRThreadSignature, CMRThreadMessage;


@interface BSMessageSampleRegistrant : NSObject {
    @private
    CMRThreadSignature *m_threadIdentifier;
    id m_delegate;
}

- (id)initWithThreadSignature:(CMRThreadSignature *)signature;

- (id)delegate;
- (void)setDelegate:(id)aDelegate;

- (void)registerMessage:(CMRThreadMessage *)message;
- (void)unregisterMessage:(CMRThreadMessage *)message;

@property(readwrite, retain) CMRThreadSignature *threadIdentifier;

@end


@interface NSObject(BSMessageSampleRegistrantDelegate)
- (NSUInteger)registrant:(BSMessageSampleRegistrant *)aRegistrant numberOfMessagesWithIDString:(NSString *)idString;
@end
