#include <string.h>
#include <cutter.h>

#include "Base64Encode.h"

void test_encode_normal_case_1(void)
{
    char *In = "ABCDEFG";
    char Out[12];
    size_t RetLen = Base64Encode(In, strlen(In), Out, sizeof(Out));
    cut_assert_equal_memory("QUJDREVGRw==", 12, Out, RetLen);
}

void test_encode_normal_case_2(void)
{
    char *In = "ABCDEFGH";
    char Out[12];
    size_t RetLen = Base64Encode(In, strlen(In), Out, sizeof(Out));
    cut_assert_equal_memory("QUJDREVGR0g=", 12, Out, RetLen);
}

void test_encode_normal_case_3(void)
{
    char *In = "ABCDEFGHI";
    char Out[12];
    size_t RetLen = Base64Encode(In, strlen(In), Out, sizeof(Out));
    cut_assert_equal_memory("QUJDREVGR0hJ", 12, Out, RetLen);
}

void test_encode_error_case_1(void)
{
    char *In = "ABCDEFG";
    char Out[11];
    size_t RetLen = Base64Encode(In, strlen(In), Out, sizeof(Out));
    cut_assert_equal_size((size_t)(-1), RetLen);
}

void test_encode_error_case_2(void)
{
    char *In = "ABCDEFGH";
    char Out[11];
    size_t RetLen = Base64Encode(In, strlen(In), Out, sizeof(Out));
    cut_assert_equal_size((size_t)(-1), RetLen);
}

void test_encode_error_case_3(void)
{
    char *In = "ABCDEFGHI";
    char Out[11];
    size_t RetLen = Base64Encode(In, strlen(In), Out, sizeof(Out));
    cut_assert_equal_size((size_t)(-1), RetLen);
}

void test_encode_table_case_0(void)
{
    char *In = "\x00\x00\x00\x04\x04\x04\x08\x08\x08\x0c\x0c\x0c";
    char Out[16];
    size_t RetLen = Base64Encode(In, 12, Out, sizeof(Out));
    cut_assert_equal_memory("AAAABAQECAgIDAwM", 16, Out, RetLen);
}

void test_encode_table_case_1(void)
{
    char *In = "\x10\x10\x10\x14\x14\x14\x18\x18\x18\x1c\x1c\x1c";
    char Out[16];
    size_t RetLen = Base64Encode(In, 12, Out, sizeof(Out));
    cut_assert_equal_memory("EBAQFBQUGBgYHBwc", 16, Out, RetLen);
}

void test_encode_table_case_2(void)
{
    char *In = "\x20\x20\x20\x24\x24\x24\x28\x28\x28\x2c\x2c\x2c";
    char Out[16];
    size_t RetLen = Base64Encode(In, 12, Out, sizeof(Out));
    cut_assert_equal_memory("ICAgJCQkKCgoLCws", 16, Out, RetLen);
}

void test_encode_table_case_3(void)
{
    char *In = "\x30\x30\x30\x34\x34\x34\x38\x38\x38\x3c\x3c\x3c";
    char Out[16];
    size_t RetLen = Base64Encode(In, 12, Out, sizeof(Out));
    cut_assert_equal_memory("MDAwNDQ0ODg4PDw8", 16, Out, RetLen);
}

void test_encode_table_case_4(void)
{
    char *In = "\x40\x40\x40\x44\x44\x44\x48\x48\x48\x4c\x4c\x4c";
    char Out[16];
    size_t RetLen = Base64Encode(In, 12, Out, sizeof(Out));
    cut_assert_equal_memory("QEBARERESEhITExM", 16, Out, RetLen);
}

void test_encode_table_case_5(void)
{
    char *In = "\x50\x50\x50\x54\x54\x54\x58\x58\x58\x5c\x5c\x5c";
    char Out[16];
    size_t RetLen = Base64Encode(In, 12, Out, sizeof(Out));
    cut_assert_equal_memory("UFBQVFRUWFhYXFxc", 16, Out, RetLen);
}

void test_encode_table_case_6(void)
{
    char *In = "\x60\x60\x60\x64\x64\x64\x68\x68\x68\x6c\x6c\x6c";
    char Out[16];
    size_t RetLen = Base64Encode(In, 12, Out, sizeof(Out));
    cut_assert_equal_memory("YGBgZGRkaGhobGxs", 16, Out, RetLen);
}

void test_encode_table_case_7(void)
{
    char *In = "\x70\x70\x70\x74\x74\x74\x78\x78\x78\x7c\x7c\x7c";
    char Out[16];
    size_t RetLen = Base64Encode(In, 12, Out, sizeof(Out));
    cut_assert_equal_memory("cHBwdHR0eHh4fHx8", 16, Out, RetLen);
}

void test_encode_table_case_8(void)
{
    char *In = "\x80\x80\x80\x84\x84\x84\x88\x88\x88\x8c\x8c\x8c";
    char Out[16];
    size_t RetLen = Base64Encode(In, 12, Out, sizeof(Out));
    cut_assert_equal_memory("gICAhISEiIiIjIyM", 16, Out, RetLen);
}

void test_encode_table_case_9(void)
{
    char *In = "\x90\x90\x90\x94\x94\x94\x98\x98\x98\x9c\x9c\x9c";
    char Out[16];
    size_t RetLen = Base64Encode(In, 12, Out, sizeof(Out));
    cut_assert_equal_memory("kJCQlJSUmJiYnJyc", 16, Out, RetLen);
}

void test_encode_table_case_a(void)
{
    char *In = "\xa0\xa0\xa0\xa4\xa4\xa4\xa8\xa8\xa8\xac\xac\xac";
    char Out[16];
    size_t RetLen = Base64Encode(In, 12, Out, sizeof(Out));
    cut_assert_equal_memory("oKCgpKSkqKiorKys", 16, Out, RetLen);
}

void test_encode_table_case_b(void)
{
    char *In = "\xb0\xb0\xb0\xb4\xb4\xb4\xb8\xb8\xb8\xbc\xbc\xbc";
    char Out[16];
    size_t RetLen = Base64Encode(In, 12, Out, sizeof(Out));
    cut_assert_equal_memory("sLCwtLS0uLi4vLy8", 16, Out, RetLen);
}

void test_encode_table_case_c(void)
{
    char *In = "\xc0\xc0\xc0\xc4\xc4\xc4\xc8\xc8\xc8\xcc\xcc\xcc";
    char Out[16];
    size_t RetLen = Base64Encode(In, 12, Out, sizeof(Out));
    cut_assert_equal_memory("wMDAxMTEyMjIzMzM", 16, Out, RetLen);
}

void test_encode_table_case_d(void)
{
    char *In = "\xd0\xd0\xd0\xd4\xd4\xd4\xd8\xd8\xd8\xdc\xdc\xdc";
    char Out[16];
    size_t RetLen = Base64Encode(In, 12, Out, sizeof(Out));
    cut_assert_equal_memory("0NDQ1NTU2NjY3Nzc", 16, Out, RetLen);
}

void test_encode_table_case_e(void)
{
    char *In = "\xe0\xe0\xe0\xe4\xe4\xe4\xe8\xe8\xe8\xec\xec\xec";
    char Out[16];
    size_t RetLen = Base64Encode(In, 12, Out, sizeof(Out));
    cut_assert_equal_memory("4ODg5OTk6Ojo7Ozs", 16, Out, RetLen);
}

void test_encode_table_case_f(void)
{
    char *In = "\xf0\xf0\xf0\xf4\xf4\xf4\xf8\xf8\xf8\xfc\xfc\xfc";
    char Out[16];
    size_t RetLen = Base64Encode(In, 12, Out, sizeof(Out));
    cut_assert_equal_memory("8PDw9PT0+Pj4/Pz8", 16, Out, RetLen);
}
