package jp.bcat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RentalCommand implements CLICommand {

	protected BookCatalog bookCatalog;
	protected RentalCatalog rentalCatalog;
	
	public RentalCommand(BookCatalog bc, RentalCatalog rc){
		bookCatalog = bc;
		rentalCatalog = rc;
	}
	
	@Override
	public void process(BufferedReader in, PrintWriter out) throws IOException {
		// TODO 自動生成されたメソッド・スタブ
		out.print("利用者ID: ");
		out.flush();
		String id = in.readLine();
		User user = null;
		
		if(user == null){
			user = new User(id);
		}
		
		out.print("貸出を希望する図書ID: ");
		out.flush();
		String bookId = in.readLine();
		Book book = bookCatalog.getBook(bookId);
		if(book == null){
			out.println("該当する図書がありません。");
			return;
		}
		
		new BookWriter(out, "  ").write(book);
		
		out.print("この図書を貸し出します。よろしいですか？(y/n)[n]: ");
		out.flush();
		
		if(!in.readLine().equals("y")){
			return;
		}
		
		String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
		RentalRecord record = new RentalRecord(id, bookId, date);
		book.setStatus("not available");
		
		rentalCatalog.addRentalRecord(record);
		out.println("貸出処理が完了しました。");
	}

}
