package errorReachableAnalyzer;

import java.io.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TransitionFileReader {
	BufferedReader reader;
	String rawData;
	String crlf=System.getProperty("line.separator");
	List<String> controllableActions;
	HashMap<String,State> stateMap;
//	String[] transitionDatas;
	public TransitionFileReader(File target){
		try {
			reader=new BufferedReader(new FileReader(target));
		} catch (FileNotFoundException e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		}
		this.controllableActions=new ArrayList<String>();
	}
	void readModelFile(){
		rawData="";
		String buf;
		try {
			long start =System.currentTimeMillis();
			int i=0,j=0;
			while((buf=reader.readLine())!=null){
				rawData+=buf.replace('	', ' ');
				if(i>1000){
					j++;
					System.out.println("current is:" +j*1000);
					i=0;
				}
				i++;//*/
			}
			long stop=System.currentTimeMillis();
			System.out.println("readModelFile:"+(stop-start));
		} catch (IOException e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		}
	}
	
	public void setControllableActions(List<String>s){
		this.controllableActions=s;
	}
/*	List<String> readTransitionSequenceFileFromLTSA(){
		rawData="";
		String buf;
		List<String> ltsa=new ArrayList<String>();
		try{
			while((buf=reader.readLine())!=null){
				rawData+=buf.split("AT.")[0].trim()+crlf;
			}
			rawData+="ERROR"+crlf;				
			ltsa.add(rawData);
		}catch(IOException e){
			e.printStackTrace();
		}
		return ltsa;
	}//*/
	String getRawData(){
		return rawData;
	}
	public Model getModel(){
		readModelFile();
		long start=System.currentTimeMillis();
		Model m=null;
		if(rawData.contains("STOP")){
			rawData=rawData.replace("STOP", "(ERROR)");
		}
		String[] transitionDatas=rawData.split("Q0,")[1].split("\\),");
		State[] stateMaterials=new State[transitionDatas.length+1];
		stateMap=new HashMap<String,State>();
		String[] transitionMaterials=new String[transitionDatas.length];
		for(int i=0;i<transitionDatas.length;i++){
			String[] buf=transitionDatas[i].split("\\=");
			stateMaterials[i]=new State(buf[0].trim());
			stateMap.put(buf[0].trim(), stateMaterials[i]);
//			System.out.println(buf[1]);//debug
			if(buf[1].indexOf("(")!=-1){
				if(buf[1].indexOf(")")!=-1){
					transitionMaterials[i]=buf[1].substring(buf[1].indexOf("(")+1,buf[1].indexOf(")"));
				}else{
					transitionMaterials[i]=buf[1].substring(buf[1].indexOf("(")+1);
				}
			}
		}
		State er=new State("ERROR");
		stateMaterials[transitionDatas.length]=er;
		stateMap.put("ERROR", er);	
		for(int i=0;i<transitionDatas.length;i++){
//debug			System.out.println("1: "+transitionMaterials[i]);
			
			if(transitionMaterials[i].indexOf("|")==-1){
				this.translateToTransition(transitionMaterials[i], stateMaterials[i]);
			}else{
				String[] t=transitionMaterials[i].split("\\|");
//debug	*/			System.out.println(t.length);
				for(int j=0;j<t.length;j++){
					if(t[j].indexOf("->")!=-1){
						this.translateToTransition(t[j], stateMaterials[i]);
					}else{
						
					}
				}				
			}
		}
		m=new Model(stateMaterials,stateMap);
		long stop=System.currentTimeMillis();
		System.out.println("making Model:"+(stop-start));

		return m;
	}
	
	private void translateToTransition(String transitionmaterial,State s){
		if(transitionmaterial.contains("->")){
			String[] ts=transitionmaterial.split("->");
			if(ts[0].contains("{")||ts[0].contains("[")){
//				List<String> tList=splitTransition(ts[0].trim());
				List<String> tList=splitTransitionForGeneral(ts[0].trim());
				for(int i=0;i<tList.size();i++){
					
					makeTransition(tList.get(i),ts[1],s);
				}
			}else{
				makeTransition(ts[0],ts[1],s);
			}			
		}else{
			s.setIsDead();
		}
	}
	
	private void makeTransition(String transitionmaterial,String toStateName,State s){
		Transition tr=new Transition(transitionmaterial.trim(),s,stateMap.get(toStateName.trim()));
		if(this.controllableActions.contains(tr.toString()))tr.setIsControllable();
		s.addToTransition(tr);
		stateMap.get(toStateName.trim()).addFromTransition(tr);
		
	}
	static List<String> splitTransition(String base){
		List<String> temp=new ArrayList<String>();
//		System.out.println(base);
		if((base.indexOf(".")<base.indexOf("{"))&&(base.indexOf(".")!=-1)){
			String b=base.substring(0,base.indexOf(".")+1).trim();
			String[] var=base.substring(base.indexOf("{")+1, base.indexOf("}")).split(",");
			for(int i=0;i<var.length;i++){
				temp.add(b+var[i].trim());
			}			
		}else{
			String a=base.substring(base.indexOf("{")+1, base.lastIndexOf("}"));
			while(a.contains(",")){
				if(a.contains("}.{")){
					String[] t=a.split("\\}\\.\\{");
					String[] front;
					if(t[0].contains("{"))front=t[0].substring(t[0].indexOf("{")+1).split(",");
					else front=t[0].split(",");
//					System.out.println(t[1]);
					String[] back;
					if(t[1].contains("}")){
						back=t[1].substring(0, t[1].indexOf("}")).split(",");
//						System.out.println(t[1].substring(0, t[1].indexOf("}")));

					}
					else back=t[1].split(",");
					for(int i=0;i<front.length;i++){
						for(int j=0;j<back.length;j++)temp.add(front[i].trim()+"."+back[j].trim());
					}
					if(a.indexOf("},")==-1)a="";
					else a=a.substring(a.indexOf("},")+2);
				}else{
					String t=a.substring(0,a.indexOf(","));
					if(a.indexOf("{")<a.indexOf(",")&&(a.indexOf("{")!=-1)){
						t=a.substring(0,a.indexOf("}"));
						String b=t.substring(0,t.indexOf(".")+1).trim();
						String[] var=t.substring(t.indexOf("{")+1).split(",");
						for(int i=0;i<var.length;i++){
							temp.add(b+var[i].trim());
						}
						a=a.substring(a.indexOf("}")+1);
						if(a.indexOf(",")==0)a=a.substring(a.indexOf(",")+1);
					}else{
						temp.add(a.substring(0,a.indexOf(",")));
						a=a.substring(a.indexOf(",")+1);
//						System.out.println("A after Processing:"+a);
					}
					if(!a.contains(","))temp.add(a.trim());
				}
			}
		}
		return temp;
	}
	
	static List<String> splitTransitionForGeneral(String base){
		while(base.contains("[")&&base.contains("..")&&base.contains("]"))base=changeString(base);
		return testSplit(base);
	}
	
	
	static String changeString(String s){
		String front="",back="",middle;
		String[] num;
		int from,to;
		while(s.contains("[")&&s.contains("..")&&s.contains("]")){
			if(s.indexOf("[")<s.indexOf("..")&&s.indexOf("..")<s.indexOf("]")){
				front=front.concat(s.substring(0,s.indexOf("[")));
				back=back.concat(s.substring(s.indexOf("]")+1));
				num=s.substring(s.indexOf("[")+1,s.indexOf("]")).split("\\.\\.");
				from=Integer.parseInt(num[0]);
				to=Integer.parseInt(num[1]);
				middle="{";
				for(int i=from;i<to;i++){
					middle+=("["+i+"]"+",");
				}
				middle+=("["+to+"]"+"}");
				return front+middle+back;	
			}else{
				front=front.concat(s.substring(0,s.indexOf("]")+1));
				s=s.substring(s.indexOf("]")+1);
			}
		}
		return s;
	}
	
	static List<String> testSplit(String s){
		List<String> temp=new ArrayList<String>();	
		while(s.contains(",")){
			if(s.contains("},")){
				temp.addAll(testSplit(s.substring(1,s.indexOf("},")+1)));
				s=s.substring(s.indexOf("},")+2).trim();
			}else if(s.contains("}.{")){
				String[] ss=s.substring(s.indexOf("{")+1,s.lastIndexOf("}")).split("\\}\\.\\{");
				List<String[]> sss=new ArrayList<String[]>();				
				for(int i=0;i<ss.length;i++){
					sss.add(ss[i].split(","));
				}
				temp.addAll(getTransitions(sss));
				s="";
			}else if(s.contains("}.")){
				String b=s.substring(s.indexOf("."));
				String c="";
				String[] ss,d;
				if(b.contains(".{")){
					c=b.substring(0,b.indexOf(".{"));
					d=b.substring(b.indexOf("{")+1,b.indexOf("}")).split(",");
					if(s.contains("{{"))ss=s.substring(s.indexOf("{{")+2,s.indexOf("}")).split(",");
					else ss=s.substring(s.indexOf("{")+1,s.indexOf("}")).split(",");
					for(int i=0;i<ss.length;i++){
						for(int j=0;j<d.length;j++){
							temp.add(ss[i]+c+"."+d[j].trim());			
						}
					}				
					if(b.substring(b.indexOf("}")+1).contains(","))s=b.substring(b.indexOf("}")+1).substring(b.indexOf(",")+1);
					else s="";
				}else{
					if(b.contains(","))c=b.substring(0,b.indexOf(","));
					else c=b.trim();
					if(s.contains("{{"))ss=s.substring(s.indexOf("{{")+2,s.indexOf("}")).split(",");
					else ss=s.substring(s.indexOf("{")+1,s.indexOf("}")).split(",");
					for(int i=0;i<ss.length;i++){
						if(ss[i].contains(c))temp.add(ss[i]);
						else if(ss[i].trim().indexOf("{")==0)temp.add(ss[i].trim().substring(ss[i].trim().indexOf("{")+1)+c);
						else temp.add(ss[i]+c);
					}
					if(b.contains(","))s=b.substring(b.indexOf(",")+1);
					else s="";
				}
			}else{
				if(s.indexOf("{")==0)s=s.substring(1);
				String head="";
				if(s.contains(".{")){
//				if(s.indexOf(".")<s.indexOf("{")&&s.indexOf(".")!=-1){
					if(!(s.indexOf(".")<s.indexOf(","))){
						head=s.substring(0,s.indexOf(".")+1).trim();
						if(head.contains(",")){
							String[] t=head.split(",");
							for(int i=0;i<t.length-1;i++){
								temp.add(t[i].trim());
							}
							head=t[t.length-1];
						}
					}else if(s.indexOf(",")>s.indexOf("{")){
						head=s.substring(0,s.indexOf(".")+1).trim();
					}
				}
				String[] ss;
				if(s.contains("}}")){
//					System.out.println("debug:"+s);
					ss=s.substring(0,s.lastIndexOf("}}")).split(",");
				}else ss=s.substring(s.indexOf("{")+1,s.lastIndexOf("}")).split(",");
//				System.out.println(ss.length);
				for(int i=0;i<ss.length;i++){
					if(ss[i].contains("{")){
						temp.add(head+ss[i].substring(ss[i].indexOf("{")+1).trim());
					}else{
						temp.add(head+ss[i].trim());						
					}
				}
				s="";
			}
		}
		if(s!="")
			if(s.contains("}"))temp.add(s.substring(0,s.indexOf("}")).trim());
			else temp.add(s.trim());
		return temp;
	}

	static List<String> getTransitions(List<String[]> s){
		return processingS(s.get(0),s.subList(1, s.size()));
	}
	
	static List<String> processingS(String[] l,List<String[]> s){
		List<String> list=new ArrayList<String>();
		if(s.size()==1){
			for(int i=0;i<l.length;i++){
				for(int j=0;j<s.get(0).length;j++){
					list.add(l[i]+"."+s.get(0)[j]);
				}				
			}
			return list;
		}else{
			List<String> c=processingS(s.get(0),s.subList(1, s.size()));
			for(int i=0;i<l.length;i++){
				for(int j=0;j<c.size();j++){
					list.add(l[i].trim()+"."+c.get(j).trim());
				}
			}
			return list;
		}
	}
}
