package errorReachableAnalyzer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DisplayModels {
	private DisplayModels 		dm=new DisplayModels();

	private DisplayModels(){
	}
	public static void displayModelWithT(ModelInterface mcm){
		for(int i=0;i<mcm.getSize();i++){
			State s=mcm.getState(i);
			System.out.println("State:"+s+"::Transition:"+s.getToTransitionNum());
		}
	}
	public static void displayStatesRate(MultiConcurrentModel mcm){
		List<String> list=new ArrayList<String>();
		HashMap<String,Integer> map=new HashMap<String,Integer>();
		for(int i=0;i<mcm.getSize();i++){
			MultiConcurrentState mcs=mcm.getState(i);
			if(list.contains(mcs.getEnv())){
				int c=map.get(mcs.getEnv())+1; 
				map.put(mcs.getEnv(),c);
			}else{
				map.put(mcs.getEnv(), 1);
				list.add(mcs.getEnv());
			}
		}
		for(int i=0;i<list.size();i++)System.out.println(list.get(i)+":"+map.get(list.get(i))+"("+((float)map.get(list.get(i))/mcm.getSize()*100)+")");
	}
	public static void displayModel(ModelInterface mcm){
		int num=0;
		for(int i=mcm.getSize()-1;i>=0;i--){
			State mcs=mcm.getState(i);
			System.out.println(mcs+":"+mcs.isDead());
			num+=mcs.getToTransitionNum();
			System.out.println(" From:");
			for(int j=0;j<mcs.getFromTransitionNum();j++){
				System.out.println("  "+mcs.getFromTransition(j));
				
			}//*/
			System.out.println(" To:");
			for(int j=0;j<mcs.getToTransitionNum();j++){
				System.out.println("  "+mcs.getToTransition(j)+"->"+mcs.getToTransition(j).getTo());
			}//*/
		}
		System.out.println("Transition num:"+num);
	}
	
	public static void displayDeadStates(ModelInterface mi){
		int num=0;
		for(int i=0;i<mi.getSize();i++){
			State mcs=mi.getState(i);
			if(mcs.getToTransitionNum()==0){
				System.out.println(mcs+":"+mcs.isDead());
				num++;
			}
		}
		System.out.println(num);
	}

	public static void displayErrorStates(MultiConcurrentModel mcm){
		for(int i=0;i<mcm.getErrorSize();i++){
			System.out.println(mcm.getErrorState(i));
		}
	}
	public static void displayStopStates(MultiConcurrentModel mcm){
		int num=0;
		for(int i=0;i<mcm.getSize();i++){
			State s=mcm.getState(i);
			for(int j=0;j<s.getToTransitionNum();j++){
				Transition t=s.getToTransition(j);
				if(t.getTo().toString().equals("STOP")){
					System.out.println(s+":"+t+"->"+t.getTo());
					num++;
				}
			}
		}
		System.out.println("AllTransitionsToSTOP:"+num);
	}
	
	public static void displayControllerState(MultiConcurrentModel mcm){
		int num=0;
		for(int i=0;i<mcm.getSize();i++){
			State s=mcm.getState(i);
			if(!s.isDead()){
				System.out.println(s);
				num++;
			}
		}
		System.out.println("Controller Size:"+num);
	}
	
	public static void displayT(ModelInterface mcm){
		int num=0;
		for(int i=0;i<mcm.getSize();i++){
			State mcs=mcm.getState(i);
			num+=mcs.getToTransitionNum();
		}//*/
		System.out.println("Transition num:"+num);
		System.out.println("Model size :"+mcm.getSize());
	}


}
