import logging,time
from cflib import crtp
from cflib.crazyflie import Crazyflie
from threading import Thread
import collector
import actor

class interface(object):
    collector =collector.collector
    actor =actor.actor
    
    def __init__(self,uri,actor,collector):
        self.collector=collector
        self.actor =actor
        self.crazyflie=Crazyflie()
        self.crazyflie.connected.add_callback(self.connected)
        self.crazyflie.disconnected.add_callback(self.disconnected)
        self.crazyflie.connection_failed.add_callback(self.connection_failed)
        self.crazyflie.connection_lost.add_callback(self.connection_lost)
        self.uri=uri
        crtp.init_drivers()
    def connected(self,uri):
        self.log =self.collector.updatee()
        self.crazyflie.log.add_config(self.log)
        
        if self.log.valid:
            self.log.data_received_cb.add_callback(self.collector.log_collector)
            self.log.start()
    def disconnected(self,uri):
        print "Disconnected from %s" %(uri)
           
    def connection_failed(self,uri,msg):
        print "Connection to %s failed: %s" %(uri,msg)

    def connection_lost(self,uri,msg):
        print "Connection to %s failed: %s" %(uri,msg)

    def getConnection(self):
        self.crazyflie.open_link(self.uri)
        self.crazyflie.connected.add_callback(self.connected)
        self.collector.makeReceiver('127.0.0.1',8000)
        Thread(target=self.puls_command).start()    

    def disConnection(self):
        self.crazyflie.close_link()

    def update(self,arg):
        collector_conf=self.collector.update()
        self.crazyflie.log.add_config(collector_conf)
    
        if collector_conf.valid:
            collector_conf.data_recieved_cb.add_collback(self.collector.log_collector)
            collector_conf.error_cb.add_callback(self.logging_error)
            collector_conf.start()
        else:
            print("Could not add logconfig since some variables are not in TOC")
   
    def logging_error(self,logconf,msg):
        print "Error when logging %s" %logconf.name
        
    def puls_command(self):
        while 1:
            self.crazyflie.commander.send_setpoint(self.actor.roll, self.actor.pitch, self.actor.yaw, self.actor.thrust)
            time.sleep(0.1)            
