from cfclient.utils.logconfigreader import LogConfig
import socket
from threading import Thread

class collector(object):
    lastMagDegree=0
    magDegree=0
    yaw=0  
    roll=0
    pitch=0  
    position=[0,0]
    def __init__(self,state=0,ip=0,port=0):
        self.moniClass="collector"
        self.collectorVlue=["magDegree","yaw","pitch","roll"]
        self.collectorType=["float","float","float","float"]
        self.moniMagValue="magDegree"
        self.moniYawValue="yaw"
        self.moniPitchValue="pitch"
        self.moniRollValue="roll"
        self.moniValueType="float" 
        if(state==1):
            self.makeReceiver(ip,port )

        
    def getDirect(self):
        return self.yaw
    def getPositionByMag(self):
        return self.magDegree
    def getPositionByCam(self):
        return self.position


    def isMoving(self):
        err=self.lastMagDegree-self.magDegree
        self.lastMagDegree=self.magDegree
        if(err>15 or err<-15):
            return 1
        else:
            return 0    
    def update(self):
        self.monitor_conf =LogConfig(self.moniClass,100)
        self.monitor_conf.add_variable(self.moniClass+"."+self.moniPitchValue,self.moniValueType)
        self.monitor_conf.add_variable(self.moniClass+"."+self.moniMagValue,self.moniValueType)
        self.monitor_conf.add_variable(self.moniClass+"."+self.moniRollValue,self.moniValueType)
        self.monitor_conf.add_variable(self.moniClass+"."+self.moniYawValue,self.moniValueType)
        return self.monitor_conf
        
    def updatee(self):
        self.collector_conf=LogConfig(self.moniClass,100)
        map(lambda x,y:self.collector_conf.add_variable(self.moniClass+"."+x,y),self.collectorVlue,self.collectorType)
        
    def log_collector(self,timestamp,data,logconf):
        self.magDegree=data[self.moniClass+"."+self.moniMagValue]
        self.yaw=data[self.moniClass+"."+self.moniYawValue]
        self.pitch=data[self.moniClass+"."+self.moniPitchValue]
        self.roll=data[self.moniClass+"."+self.moniRollValue]
        
    
##################################################################
#if you need position, you activate this function
#and when the robot' move finish, you must call destroyReciever
    def makeReceiver(self,ipAddress,portNum):
        self.host=ipAddress
        self.port=portNum
        self.backlog=10
        self.bufsize=4096
        self.activate=1
        self.sock=socket.socket(socket.AF_INET,socket.SOCK_STREAM)
        self.sock.connect((self.host,self.port))
        self.th=Thread(target=self.receive)
        self.th.start()
    def destroyReciever(self):
        self.activate=0 
        self.sock.close()
    def receive(self):
        while(self.activate==1):
            self.x=self.sock.recv(self.bufsize)
            self.y=self.sock.recv(self.bufsize)
            self.position=[float(self.x),float(self.y)]