/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package android.i18n;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.WindowConstants;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/**
 *
 * @author nobuo
 */
public class Android_i18n {

    static JFrame frame;
    JTable table;
    JScrollPane scroll;
    DefaultTableModel model;

    private static KeyStroke CUT;
    private static KeyStroke COPY;
    private static KeyStroke PASTE;
    private static KeyStroke ADDROW;
    private static KeyStroke INSROW;
    private static KeyStroke DELROW;

    public Android_i18n() {
        //frame = new JFrame();
        frame = createFrame("Android i18n");
        //frame.setTitle("Android i18n");
        frame.setSize(new Dimension(512, 256));
        frame.setLocationRelativeTo(null);
        //frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        setKeyStroke();

        model = new DefaultTableModel(40, 4);
        table = new JTable(model);
        MenuBuilder mb = new MenuBuilder(table, model);
        frame.add(mb.getMenuBar(), BorderLayout.NORTH);
        scroll = new JScrollPane(table);

        // 右クリック用のメニューを定義
        initializeRightClickMenu(table);
        // キーボードショートカットを登録
        initializeKeyShortCut(table);

        frame.add(scroll, BorderLayout.CENTER);

        JTableHeader jh = table.getTableHeader();
        jh.setReorderingAllowed(false);// テーブルの列移動を不許可にする。
        jh.setFont(new Font(jh.getFont().getFamily(), Font.BOLD, 12));
        Object[] cnames = {"node", "name", "en", "ja"};
        TableColumnModel columnModel = table.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); i++) {
            TableColumn tc = columnModel.getColumn(i);
            tc.setHeaderValue(cnames[i]);
        }

        //table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        //TableColumn column = null;
        //columnModel.getColumn(0).setMaxWidth(60);
        //columnModel.getColumn(1).setPreferredWidth(70);
        // それぞれのカラムにレンダラーを設定 
        table.getColumnModel().getColumn(0).setCellRenderer(new ButtonCellRenderer());
        // レンダラーで表示するボタンはダミーで、ボタンのクリックイベントはセルエディターの方で受け取ります。
        table.getColumnModel().getColumn(0)
                .setCellEditor(new ButtonCellEditor(frame, table, new JButton()));

        // １セル選択可能とする
        table.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_INTERVAL_SELECTION);
        table.setCellSelectionEnabled(true);
        table.setRowSelectionAllowed(true);

        table.requestFocus();
        table.changeSelection(0, 1, false, false);

        initStatusBar(frame.getContentPane());
        //Container contentPane = getContentPane();
    }

    private static int number = 0;
    
    public static JFrame createFrame(String title) {
        //JFrame cframe = new JFrame((title==null)?"Frame #"+number:title);
        
        JFrame cframe = new JFrame(title + "  File : project " + number);
        cframe.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        number++;
        cframe.addWindowListener(new WindowAdapter() {
            @Override public void windowClosing(WindowEvent e) {
                number--;
                if(number==0) {
                    JFrame f = (JFrame)e.getWindow();
                    f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                }
            }
        });
        return cframe;
    }
    
    private void initStatusBar(Container c) {
        // ステータスバー
        JPanel bar = new JPanel(new FlowLayout(FlowLayout.LEFT));
        //bar.setBorder(new BevelBorder(BevelBorder.RAISED));

        bar.add(new JLabel("status"));
        bar.add(new JLabel("status2"));

        c.add(bar, BorderLayout.PAGE_END);
    }

    private void setKeyStroke() {
        // キーストロークの設定    
        CUT = KeyStroke.getKeyStroke(KeyEvent.VK_X, ActionEvent.CTRL_MASK, false);
        COPY = KeyStroke.getKeyStroke(KeyEvent.VK_C, ActionEvent.CTRL_MASK, false);
        PASTE = KeyStroke.getKeyStroke(KeyEvent.VK_V, ActionEvent.CTRL_MASK, false);
        ADDROW = KeyStroke.getKeyStroke(KeyEvent.VK_A, ActionEvent.CTRL_MASK, false);
        INSROW = KeyStroke.getKeyStroke(KeyEvent.VK_INSERT, ActionEvent.SHIFT_MASK, false);
        DELROW = KeyStroke.getKeyStroke(KeyEvent.VK_DELETE, ActionEvent.SHIFT_MASK, false);

    }

    /**
     * キーボードショートカットの登録を行います。
     *
     * @param table キーボードショートカットを登録するテーブル
     */
    private void initializeKeyShortCut(JTable xtable) {
        // キーイベント用アクション生成
        EditActionListener ea = new EditActionListener(xtable, model);
        EditActionListener.EditCut actionCut = ea.new EditCut();
        EditActionListener.EditCopy actionCopy = ea.new EditCopy();
        EditActionListener.EditPaste actionPaste = ea.new EditPaste();
        EditActionListener.EditAddRow actionAddRow = ea.new EditAddRow();
        EditActionListener.EditInsertRow actionInsRow = ea.new EditInsertRow();
        EditActionListener.EditDeleteRow actionDelRow = ea.new EditDeleteRow();

        // キーの登録
        ActionEvent e;
        xtable.getInputMap().put(CUT, "Cut");				// 切り取り
        xtable.getActionMap().put("Cut", actionCut);
        xtable.getInputMap().put(COPY, "Copy");				// コピー
        xtable.getActionMap().put("Copy", (Action) actionCopy);
        xtable.getInputMap().put(PASTE, "Paste");			// 貼り付け
        xtable.getActionMap().put("Paste", (Action) actionPaste);
        xtable.getInputMap().put(ADDROW, "AddRow");			// 行追加
        xtable.getActionMap().put("AddRow", (Action) actionAddRow);
        xtable.getInputMap().put(INSROW, "InsRow");			// 行挿入
        xtable.getActionMap().put("InsRow", (Action) actionInsRow);
        xtable.getInputMap().put(DELROW, "DelRow");			// 行削除
        xtable.getActionMap().put("DelRow", (Action) actionDelRow);
    }

    /**
     * 右クリックメニュー初期化を行います。
     *
     * @param table 右クリックを行うテーブル
     */
    private void initializeRightClickMenu(JTable xtable) {
        // 右クリック用のメニューを定義
        JMenuItem jmnuCut, jmnuCopy, jmnuPaste, 
                jmnuAddRow, jmnuInsertRow, jmnuDeleteRow;
        
        jmnuCut   = new JMenuItem("Cut    CTRL+X");	// 切り取り
        jmnuCopy  = new JMenuItem("Copy   CTRL+C");	// コピー
        jmnuPaste = new JMenuItem("Paste  CTRL+V");	// 貼り付け
        jmnuAddRow = new JMenuItem("AddRow  CTRL+A");	// 行追加
        jmnuInsertRow = new JMenuItem("InsertRow  SHIFT+Insert");   // 行挿入
        jmnuDeleteRow = new JMenuItem("DeleteRow  SHIFT+Delete");   // 行削除

        // 右クリック用アクションリスナー生成
        EditActionListener listener
                = new EditActionListener(xtable, model);
        // 各メニュー選択時の処理
        jmnuCut.addActionListener(listener.new EditCut());
        jmnuCopy.addActionListener(listener.new EditCopy());
        jmnuPaste.addActionListener(listener.new EditPaste());
        jmnuAddRow.addActionListener(listener.new EditAddRow());
        jmnuInsertRow.addActionListener(listener.new EditInsertRow());
        jmnuDeleteRow.addActionListener(listener.new EditDeleteRow());

        // 右クリック時に表示するポップアップを定義
        JPopupMenu jpopup = new JPopupMenu();
        jpopup.add(jmnuCut);		// Cut    CTRL+X
        jpopup.add(jmnuCopy);		// Copy   CTRL+C
        jpopup.add(jmnuPaste);		// Paste  CTRL+V
        jpopup.add(jmnuAddRow);		// AddRow  CTRL+A
        jpopup.add(jmnuInsertRow);	// InsertRow  SHIFT+Insert
        jpopup.add(jmnuDeleteRow);	// DeleteRow  SHIFT+Delete

        // マウスイベント用リスナー追加
        xtable.addMouseListener(new EditMouseListener(xtable, jpopup));
        // ポップアップをフレームに設定
        //frame.add(jpopup);
    }

 
    public JFrame getFrame() {
        return frame;
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        Android_i18n ai = new Android_i18n();
        //frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setVisible(true);
    }

//    @Override
//    public void actionPerformed(ActionEvent e) {
//        model.addColumn(null);  // 列追加
//        model.addRow(new Vector()); // 行追加
//    }
}
