# declaration of function

function(get_source_directory output dir)
  set(${output} "${CMAKE_CURRENT_SOURCE_DIR}/../${dir}" PARENT_SCOPE)
endfunction()

function(get_build_directory output source_dir enable_suffix)
  string(TOLOWER ${CMAKE_BUILD_TYPE} CMAKE_BUILD_TYPE_TOLOWER)
  set(BUILD_DIRECTORY "build-${CMAKE_BUILD_TYPE_TOLOWER}")
  if(enable_suffix)
    set(${output} "${${source_dir}}/${BUILD_DIRECTORY}-native" PARENT_SCOPE)
  else()
    set(${output} "${${source_dir}}/${BUILD_DIRECTORY}" PARENT_SCOPE)
  endif()
endfunction()

function(get_local_library_directory_named output source_dir lib_dir)
  string(TOLOWER ${CMAKE_BUILD_TYPE} CMAKE_BUILD_TYPE_TOLOWER)
  get_build_directory(build_dir ${source_dir} OFF)
  if(MSVC)
    set(${output} "${build_dir}/${lib_dir}/${CMAKE_BUILD_TYPE_TOLOWER}" PARENT_SCOPE)
  else()
    set(${output} "${build_dir}/${lib_dir}" PARENT_SCOPE)
  endif()
endfunction()

function(get_local_library_directory output source_dir)
  get_local_library_directory_named(output_to_reassign ${source_dir} "lib")
  set(${output} ${output_to_reassign} PARENT_SCOPE)
endfunction()

function(set_dll_properties target)
  if(WIN32 AND BUILD_SHARED_LIBS)
    set_target_properties(${target} PROPERTIES PREFIX "" SUFFIX .dll IMPORT_SUFFIX ${CMAKE_IMPORT_LIBRARY_SUFFIX})
  endif()
endfunction()

function(get_install_directory output dir)
  get_source_directory(source_dir ${dir})
  string(TOLOWER ${CMAKE_BUILD_TYPE} CMAKE_BUILD_TYPE_TOLOWER)
  set(build_dir "build-${CMAKE_BUILD_TYPE_TOLOWER}")
  set(${output} "${source_dir}/${build_dir}/install-root" PARENT_SCOPE)
endfunction()

function(create_osx_framework target public_headers)
  # create as a framework if build on darwin environment
  if(APPLE)
    if(BUILD_SHARED_LIBS AND FRAMEWORK)
      install(TARGETS vpvl2 DESTINATION .)
      set_target_properties(${target} PROPERTIES FRAMEWORK true PROPERTIES PUBLIC_HEADER "${public_headers}")
    endif()
    set_target_properties(vpvl2 PROPERTIES INSTALL_NAME_DIR "${CMAKE_INSTALL_PREFIX}/lib")
  endif()
endfunction()

function(vpvl2_link_bullet target)
  target_link_libraries(${target} ${BULLET_DYNAMICS_LIB}
                                  ${BULLET_COLLISION_LIB}
                                  ${BULLET_SOFTBODY_LIB}
                                  ${BULLET_MULTITHREADED_LIB}
                                  ${BULLET_LINEARMATH_LIB})
endfunction()

function(vpvl2_find_bullet)
  get_install_directory(BULLET_INSTALL_DIR "bullet-src")
  find_path(BULLET_INCLUDE_DIR NAMES btBulletCollisionCommon.h PATH_SUFFIXES include/bullet PATHS ${BULLET_INSTALL_DIR} NO_DEFAULT_PATH)
  find_library(BULLET_LINEARMATH_LIB LinearMath PATH_SUFFIXES lib64 lib32 lib PATHS ${BULLET_INSTALL_DIR} NO_DEFAULT_PATH)
  find_library(BULLET_COLLISION_LIB BulletCollision PATH_SUFFIXES lib64 lib32 lib PATHS ${BULLET_INSTALL_DIR} NO_DEFAULT_PATH)
  find_library(BULLET_DYNAMICS_LIB BulletDynamics PATH_SUFFIXES lib64 lib32 lib PATHS ${BULLET_INSTALL_DIR} NO_DEFAULT_PATH)
  find_library(BULLET_MULTITHREADED_LIB BulletMultiThreaded PATH_SUFFIXES lib64 lib32 lib PATHS ${BULLET_INSTALL_DIR} NO_DEFAULT_PATH)
  find_library(BULLET_SOFTBODY_LIB BulletSoftBody PATH_SUFFIXES lib64 lib32 lib PATHS ${BULLET_INSTALL_DIR} NO_DEFAULT_PATH)
  include_directories(${BULLET_INCLUDE_DIR})
endfunction()

function(vpvl2_link_assimp target)
  if(VPVL2_LINK_ASSIMP)
    target_link_libraries(${target} ${ASSIMP_LIBRARY})
  endif()
endfunction()

function(vpvl2_find_assimp)
  if(VPVL2_LINK_ASSIMP)
    get_install_directory(ASSIMP_INSTALL_DIR "assimp-src")
    find_path(ASSIMP_INCLUDE_DIR NAMES assimp.h PATH_SUFFIXES include/assimp PATHS ${ASSIMP_INSTALL_DIR} NO_DEFAULT_PATH)
    find_library(ASSIMP_LIBRARY assimp PATH_SUFFIXES lib64 lib32 lib PATHS ${ASSIMP_INSTALL_DIR} NO_DEFAULT_PATH)
    include_directories(${ASSIMP_INCLUDE_DIR})
  endif()
endfunction()

function(vpvl2_link_vpvl target)
  if(VPVL2_LINK_VPVL)
    target_link_libraries(${target} ${VPVL_LIBRARY})
  endif()
endfunction()

function(vpvl2_find_vpvl)
  if(VPVL2_LINK_VPVL)
    get_install_directory(VPVL_INSTALL_DIR "libvpvl")
    find_path(VPVL_INCLUDE_DIR NAMES vpvl/vpvl.h PATH_SUFFIXES include PATHS ${VPVL_INSTALL_DIR} NO_DEFAULT_PATH)
    find_library(VPVL_LIBRARY vpvl PATH_SUFFIXES lib64 lib32 lib PATHS ${VPVL_INSTALL_DIR} NO_DEFAULT_PATH)
    include_directories(${VPVL_INCLUDE_DIR})
  endif()
endfunction()

function(vpvl2_link_glew target)
  if(VPVL2_ENABLE_EXTENSIONS_RENDERCONTEXT)
    target_link_libraries(${target} ${GLEW_LIBRARY})
    if(MSVC)
      target_link_libraries(${target} ${GLEW_MX_LIBRARY})
    endif()
  endif()
endfunction()

function(vpvl2_find_glew)
  if(VPVL2_ENABLE_EXTENSIONS_RENDERCONTEXT AND VPVL2_LINK_GLEW AND NOT VPVL2_ENABLE_GLES2)
    find_library(GLEW_LIBRARY GLEW glew glew32s PATHS ${CMAKE_CURRENT_SOURCE_DIR}/../glew-src/lib)
    if(MSVC)
      find_library(GLEW_MX_LIBRARY glew32mxs PATHS ${CMAKE_CURRENT_SOURCE_DIR}/../glew-src/lib)
    endif()
    find_path(GLEW_INCLUDE_DIR GL/glew.h PATHS ${CMAKE_CURRENT_SOURCE_DIR}/../glew-src/include)
    include_directories(${GLEW_INCLUDE_DIR})
  endif()
endfunction()

function(vpvl2_link_nvtt target)
  if(VPVL2_LINK_NVTT)
    target_link_libraries(${target} ${NVTT_NVCORE_LIBRARY} ${NVTT_NVIMAGE_LIBRARY} ${NVTT_NVMATH_LIBRARY})
  endif()
endfunction()

function(vpvl2_find_nvtt)
  if(VPVL2_ENABLE_EXTENSIONS_RENDERCONTEXT AND VPVL2_LINK_NVTT)
    get_source_directory(NVTT_SOURCE_DIRECTORY "nvtt-src")
    get_build_directory(NVTT_BUILD_DIRECTORY NVTT_SOURCE_DIRECTORY OFF)
    set(NVTT_INCLUDE_DIRECTORY "${NVTT_SOURCE_DIRECTORY}/src")
    # for MSVC
    find_path(NVTT_CONFIG_INCLUDE_DIR nvconfig.h PATHS "${NVTT_BUILD_DIRECTORY}/src" NO_DEFAULT_PATH)
    find_path(NVTT_BASE_INCLUDE_DIR nvcore/nvcore.h PATHS ${NVTT_INCLUDE_DIRECTORY} NO_DEFAULT_PATH)
    find_path(NVTT_POSH_INCLUDE_DIR posh.h PATHS "${NVTT_SOURCE_DIRECTORY}/extern/poshlib" NO_DEFAULT_PATH)
    if (NVTT_CONFIG_INCLUDE_DIR AND NVTT_BASE_INCLUDE_DIR AND NVTT_POSH_INCLUDE_DIR)
      include_directories(${NVTT_CONFIG_INCLUDE_DIR} ${NVTT_BASE_INCLUDE_DIR} ${NVTT_POSH_INCLUDE_DIR})
    else()
      message(FATAL_ERROR "Required nvtt is not found.")
    endif()
    get_install_directory(NVTT_INSTALL_DIR "nvtt-src")
    find_library(NVTT_NVCORE_LIBRARY nvcore PATH_SUFFIXES lib64 lib32 lib PATHS ${NVTT_INSTALL_DIR} NO_DEFAULT_PATH)
    find_library(NVTT_NVMATH_LIBRARY nvimage PATH_SUFFIXES lib64 lib32 lib PATHS ${NVTT_INSTALL_DIR} NO_DEFAULT_PATH)
    find_library(NVTT_NVIMAGE_LIBRARY nvimage PATH_SUFFIXES lib64 lib32 lib PATHS ${NVTT_INSTALL_DIR} NO_DEFAULT_PATH)
  endif()
endfunction()

function(vpvl2_find_sfml)
  if(VPVL2_ENABLE_EXTENSIONS_RENDERCONTEXT AND VPVL2_LINK_SFML)
    find_library(SFML_GRAPHICS_LIBRARY sfml-graphics)
    find_library(SFML_SYSTEM_LIBRARY sfml-system)
    find_library(SFML_WINDOW_LIBRARY sfml-window)
    find_path(SFML_INCLUDE_DIR SFML/System.h)
    include_directories(${SFML_INCLUDE_DIR})
  endif()
endfunction()

function(vpvl2_find_openmp)
  if(VPVL2_ENABLE_OPENMP)
    find_package(OpenMP)
    if(OPENMP_FOUND)
      set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} ${OpenMP_C_FLAGS}")
      set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${OpenMP_CXX_FLAGS}")
    endif()
  endif()
endfunction()

function(vpvl2_link_icu target)
  if(ICU_LIBRARY_I18N AND ICU_LIBRARY_UC AND ICU_LIBRARY_DATA)
    target_link_libraries(${target} ${ICU_LIBRARY_I18N} ${ICU_LIBRARY_UC} ${ICU_LIBRARY_DATA})
  endif()
endfunction()

function(vpvl2_find_icu)
  if(VPVL2_ENABLE_EXTENSIONS_STRING)
    get_install_directory(ICU_INSTALL_DIR "icu-src")
    find_path(ICU_INCLUDE_DIR NAMES unicode/unistr.h PATH_SUFFIXES include PATHS ${ICU_INSTALL_DIR} NO_DEFAULT_PATH)
    find_library(ICU_LIBRARY_DATA icudata icudt PATH_SUFFIXES lib64 lib32 lib PATHS ${ICU_INSTALL_DIR} NO_DEFAULT_PATH)
    find_library(ICU_LIBRARY_UC icuuc icuuc PATH_SUFFIXES lib64 lib32 lib PATHS ${ICU_INSTALL_DIR} NO_DEFAULT_PATH)
    find_library(ICU_LIBRARY_I18N icui18n icuin PATH_SUFFIXES lib64 lib32 lib PATHS ${ICU_INSTALL_DIR} NO_DEFAULT_PATH)
    include_directories(${ICU_INCLUDE_DIR})
  endif()
endfunction()

function(vpvl2_link_tbb target)
  if(TBB_LIBRARY_DIRS)
    string(TOLOWER "${CMAKE_BUILD_TYPE}" CMAKE_BUILD_TYPE_TOLOWER)
    if(CMAKE_BUILD_TYPE_TOLOWER STREQUAL "debug" AND TBB_LIBRARY_DEBUG AND TBB_MALLOC_LIBRARY_DEBUG)
      target_link_libraries(${target} ${TBB_LIBRARY_DEBUG} ${TBB_MALLOC_LIBRARY_DEBUG})
    else()
      target_link_libraries(${target} ${TBB_LIBRARY} ${TBB_MALLOC_LIBRARY})
    endif()
  endif()
endfunction()

function(vpvl2_find_tbb)
  if(VPVL2_LINK_INTEL_TBB)
    find_package(TBB REQUIRED)
    link_directories(${TBB_LIBRARY_DIRS})
    include_directories(${TBB_INCLUDE_DIRS})
  endif()
endfunction()

function(vpvl2_link_zlib target)
  if(ZLIB_LIBRARY)
    target_link_libraries(${target} ${ZLIB_LIBRARY})
  endif()
endfunction()

function(vpvl2_find_zlib)
  get_source_directory(ZLIB_SOURCE_DIRECTORY "zlib-src")
  get_build_directory(ZLIB_BUILD_DIRECTORY ZLIB_SOURCE_DIRECTORY OFF)
  get_local_library_directory(ZLIB_LIBRARY_LOCAL_DIR ZLIB_SOURCE_DIRECTORY)
  find_library(ZLIB_LIBRARY z zlibstatic PATHS ${ZLIB_LIBRARY_LOCAL_DIR} NO_DEFAULT_PATH)
  find_path(ZLIB_INCLUDE_DIR zlib.h PATHS ${ZLIB_SOURCE_DIRECTORY} NO_DEFAULT_PATH)
  find_path(ZLIB_INCLUDE_CONFIG_DIR zconf.h PATHS ${ZLIB_BUILD_DIRECTORY} NO_DEFAULT_PATH)
  include_directories(${ZLIB_INCLUDE_DIR} ${ZLIB_INCLUDE_CONFIG_DIR})
endfunction()

function(vpvl2_link_libxml2 target)
  if(LIBXML2_LIBRARY)
    target_link_libraries(${target} ${LIBXML2_LIBRARY})
  endif()
endfunction()

function(vpvl2_find_libxml2)
  if(VPVL2_ENABLE_EXTENSIONS_PROJECT)
    get_install_directory(LIBXML2_INSTALL_DIR "libxml2-src")
    find_path(LIBXML2_INCLUDE_DIR NAMES libxml/xmlwriter.h PATH_SUFFIXES include/libxml2 PATHS ${LIBXML2_INSTALL_DIR} NO_DEFAULT_PATH)
    find_library(LIBXML2_LIBRARY xml2 libxml2_a libxml2 PATH_SUFFIXES lib64 lib32 lib PATHS ${LIBXML2_INSTALL_DIR} NO_DEFAULT_PATH)
    include_directories(${LIBXML2_INCLUDE_DIR})
  endif()
endfunction()

function(vpvl2_find_opengl)
  if(VPVL2_ENABLE_GLES2)
    find_path(OPENGL_INCLUDE_DIR "GLES2/gl2.h")
    if(VPVL2_PLATFORM_NACL)
      find_library(OPENGL_gl_LIBRARY ppapi_gles2)
    elseif(NOT VPVL2_PLATFORM_EMSCRIPTEN)
      find_library(OPENGL_gl_LIBRARY GLESv2)
    endif()
  else()
    find_package(OpenGL REQUIRED)
  endif()
endfunction()

function(vpvl2_link_cg_runtime target)
  if(CG_LIBRARY AND CG_GL_LIBRARY)
    target_link_libraries(${target} ${CG_LIBRARY} ${CG_GL_LIBRARY})
  endif()
endfunction()

function(vpvl2_find_cg_runtime)
  if(VPVL2_ENABLE_NVIDIA_CG AND VPVL2_ENABLE_EXTENSIONS_RENDERCONTEXT)
    find_package(Cg REQUIRED)
    # workaround for framework include path
    if(APPLE)
      find_path(CG_INCLUDE_DIR_APPLE "Cg/cg.h" STRING CACHE)
      set(CG_INCLUDE_DIR ${CG_INCLUDE_DIR_APPLE})
    endif()
    include_directories(${CG_INCLUDE_DIR})
  endif()
endfunction()

function(vpvl2_link_cl_runtime target)
  if(OPENCL_LIBRARY)
    target_link_libraries(${target} ${OPENCL_LIBRARY})
  endif()
endfunction()

function(vpvl2_find_cl_runtime)
  if(VPVL2_ENABLE_OPENCL)
    find_library(OPENCL_LIBRARY OpenCL)
    if(APPLE)
      find_path(OPENCL_INCLUDE_DIR "OpenCL/cl.h")
    else()
      find_path(OPENCL_INCLUDE_DIR "CL/cl.h")
    endif()
    include_directories(${OPENCL_INCLUDE_DIR})
  endif()
endfunction()

function(vpvl2_find_glm)
  get_source_directory(GLM_SOURCE_DIRECTORY "glm-src")
  find_path(GLM_INCLUDE_DIR "glm/glm.hpp" PATHS ${GLM_SOURCE_DIRECTORY})
  include_directories(${GLM_INCLUDE_DIR})
endfunction()

function(vpvl2_find_all)
  vpvl2_find_glm()
  vpvl2_find_zlib()
  vpvl2_find_libxml2()
  vpvl2_find_cg_runtime()
  vpvl2_find_tbb()
  vpvl2_find_bullet()
  vpvl2_find_assimp()
  vpvl2_find_glew()
  vpvl2_find_icu()
  vpvl2_find_nvtt()
  vpvl2_find_vpvl()
  vpvl2_find_cl_runtime()
  vpvl2_find_openmp()
endfunction()

function(vpvl2_link_all target)
  vpvl2_link_zlib(${target})
  vpvl2_link_libxml2(${target})
  vpvl2_link_tbb(${target})
  vpvl2_link_bullet(${target})
  vpvl2_link_assimp(${target})
  vpvl2_link_glew(${target})
  vpvl2_link_icu(${target})
  vpvl2_link_nvtt(${target})
  vpvl2_link_vpvl(${target})
  vpvl2_link_cl_runtime(${target})
  vpvl2_link_cg_runtime(${target})
endfunction()
# end of functions
