﻿using System.Text;
using System.Collections.ObjectModel;
using System.ComponentModel;
using Windows.UI.Xaml.Controls;
using System.Runtime.CompilerServices;
using EncodeDetect;

// ユーザー コントロールのアイテム テンプレートについては、http://go.microsoft.com/fwlink/?LinkId=234236 を参照してください

namespace FooEditor
{
    public sealed partial class PropertyFlyout : Page,INotifyPropertyChanged
    {
        FileType _FileType;
        Encoding _Encode;
        LineFeedType _LineFeed;
        
        static ObservableCollection<Encoding> encodeCollection = new ObservableCollection<Encoding>();
        static ObservableCollection<LineFeedType> lineFeedCollection = new ObservableCollection<LineFeedType>();

        public PropertyFlyout()
        {
            this.InitializeComponent();
            this.FlyoutContent.DataContext = this;
            if (encodeCollection.Count == 0)
            {
                encodeCollection.Add(Encoding.GetEncoding("utf-32"));
                encodeCollection.Add(Encoding.GetEncoding("utf-32BE"));
                encodeCollection.Add(Encoding.GetEncoding("utf-16"));
                encodeCollection.Add(Encoding.GetEncoding("unicodeFFFE"));
                encodeCollection.Add(Encoding.GetEncoding("iso-2022-jp"));
                encodeCollection.Add(Encoding.GetEncoding("us-ascii"));
                encodeCollection.Add(Encoding.GetEncoding("euc-jp"));
                encodeCollection.Add(Encoding.GetEncoding("shift_jis"));
                encodeCollection.Add(new UTF8Encoding());
            }
            if (lineFeedCollection.Count == 0)
            {
                lineFeedCollection.Add(LineFeedType.CR);
                lineFeedCollection.Add(LineFeedType.CRLF);
                lineFeedCollection.Add(LineFeedType.LF);
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        public FileType DocumentType
        {
            get
            {
                return this._FileType;
            }
            set
            {
                this._FileType = value;
                this.OnPropertyChanged();
            }
        }

        public Encoding Encode
        {
            get
            {
                return this._Encode;
            }
            set
            {
                this._Encode = value;
                this.OnPropertyChanged();
            }
        }

        public LineFeedType LineFeed
        {
            get
            {
                return this._LineFeed;
            }
            set
            {
                this._LineFeed = value;
                this.OnPropertyChanged();
            }
        }

        public ObservableCollection<FileType> FileTypeCollection
        {
            get
            {
                return AppSettings.Current.FileTypeCollection;
            }
        }

        public ObservableCollection<Encoding> EncodeCollection
        {
            get
            {
                return encodeCollection;
            }
        }

        public ObservableCollection<LineFeedType> LineFeedCollection
        {
            get
            {
                return lineFeedCollection;
            }
        }

        void OnPropertyChanged([CallerMemberName] string propertyName = null)
        {
            var eventHandler = this.PropertyChanged;
            if (eventHandler != null)
            {
                eventHandler(this, new PropertyChangedEventArgs(propertyName));
            }
        }
    }
}
