﻿using System;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using FooEditEngine;
using FooEditEngine.Metro;

// ユーザー コントロールのアイテム テンプレートについては、http://go.microsoft.com/fwlink/?LinkId=234236 を参照してください

namespace FooEditor
{
    public sealed partial class FindFlyout : UserControl
    {
        FindFlyoutModel model;
        public FindFlyout()
        {
            this.InitializeComponent();
            this.DataContext = this;
        }

        public FindFlyout(FooTextBox textbox)
            : this()
        {
            this.model = new FindFlyoutModel(textbox);
        }

        public string FindPattern
        {
            get { return (string)GetValue(FindPatternProperty); }
            set { SetValue(FindPatternProperty, value); }
        }

        // Using a DependencyProperty as the backing store for FindPattern.  This enables animation, styling, binding, etc...
        public static readonly DependencyProperty FindPatternProperty =
            DependencyProperty.Register("FindPattern", typeof(string), typeof(FindFlyout), new PropertyMetadata(string.Empty));

        public string ReplacePattern
        {
            get { return (string)GetValue(ReplacePatternProperty); }
            set { SetValue(ReplacePatternProperty, value); }
        }

        // Using a DependencyProperty as the backing store for ReplacePattern.  This enables animation, styling, binding, etc...
        public static readonly DependencyProperty ReplacePatternProperty =
            DependencyProperty.Register("ReplacePattern", typeof(string), typeof(FindFlyout), new PropertyMetadata(string.Empty));

        public bool UseRegEx
        {
            get { return (bool)GetValue(UseRegExProperty); }
            set { SetValue(UseRegExProperty, value); }
        }

        // Using a DependencyProperty as the backing store for UseRegEx.  This enables animation, styling, binding, etc...
        public static readonly DependencyProperty UseRegExProperty =
            DependencyProperty.Register("UseRegEx", typeof(bool), typeof(FindFlyout), new PropertyMetadata(false));

        public bool RestrictSearch
        {
            get { return (bool)GetValue(RestrictSearchProperty); }
            set { SetValue(RestrictSearchProperty, value); }
        }

        // Using a DependencyProperty as the backing store for RestrictSearch.  This enables animation, styling, binding, etc...
        public static readonly DependencyProperty RestrictSearchProperty =
            DependencyProperty.Register("RestrictSearch", typeof(bool), typeof(FindFlyout), new PropertyMetadata(false));

        public bool UseGroup
        {
            get { return (bool)GetValue(UseGroupProperty); }
            set { SetValue(UseGroupProperty, value); }
        }

        // Using a DependencyProperty as the backing store for UseGroup.  This enables animation, styling, binding, etc...
        public static readonly DependencyProperty UseGroupProperty =
            DependencyProperty.Register("UseGroup", typeof(bool), typeof(FindFlyout), new PropertyMetadata(false));

        public string Result
        {
            get { return (string)GetValue(ResultProperty); }
            set { SetValue(ResultProperty, value); }
        }

        // Using a DependencyProperty as the backing store for Result.  This enables animation, styling, binding, etc...
        public static readonly DependencyProperty ResultProperty =
            DependencyProperty.Register("Result", typeof(string), typeof(FindFlyout), new PropertyMetadata(string.Empty));

        
        public DelegateCommand<object> FindNextCommand
        {
            get
            {
                return new DelegateCommand<object>((s) => {
                    this.Result = string.Empty;
                    try
                    {
                        RegexOptions opt = this.RestrictSearch ? RegexOptions.None : RegexOptions.IgnoreCase;
                        this.model.FindNext(this.FindPattern, this.UseRegEx, opt);
                    }
                    catch (Exception e)
                    {
                        this.Result = e.Message;
                    }
                });
            }
        }

        public DelegateCommand<object> ReplaceNextCommand
        {
            get
            {
                return new DelegateCommand<object>((s) => {
                    this.Result = string.Empty;
                    try
                    {
                        this.model.Replace(this.ReplacePattern, this.UseGroup);
                        RegexOptions opt = this.RestrictSearch ? RegexOptions.None : RegexOptions.IgnoreCase;
                        this.model.FindNext(this.FindPattern, this.UseRegEx, opt);
                    }
                    catch (Exception e)
                    {
                        this.Result = e.Message;
                    }
                });
            }
        }

        public DelegateCommand<object> ReplaceAllCommand
        {
            get
            {
                return new DelegateCommand<object>((s) => {
                    this.Result = string.Empty;
                    try
                    {
                        RegexOptions opt = this.RestrictSearch ? RegexOptions.IgnoreCase : RegexOptions.None;
                        this.model.ReplaceAll(this.FindPattern, this.ReplacePattern, this.UseGroup, this.UseRegEx, opt);
                    }
                    catch (Exception e)
                    {
                        this.Result = e.Message;
                    }
                });
            }
        }
    }

    class FindFlyoutModel
    {
        FooTextBox textBox;
        IEnumerator<SearchResult> iterator;
        bool canReplaceNext = false;
        string currentPatter;
        public FindFlyoutModel(FooTextBox textbox)
        {
            this.textBox = textbox;
        }

        public bool IsCanReplaceNext()
        {
            return this.canReplaceNext;
        }
        
        public void FindNext(string pattern, bool useregex, RegexOptions opt)
        {
            if (this.iterator == null || this.currentPatter != pattern)
            {
                this.currentPatter = pattern;
                this.textBox.Document.SetFindParam(pattern, useregex, opt);
                this.iterator = this.textBox.Document.Find();
            }
            if (!this.iterator.MoveNext())
            {
                this.canReplaceNext = false;
                return;
            }
            SearchResult sr = this.iterator.Current;
            this.textBox.JumpCaret(sr.End);
            this.textBox.Select(sr.Start, sr.End - sr.Start + 1);
            this.textBox.Refresh();
            this.canReplaceNext = true;
            return;
        }

        public void Replace(string newpattern, bool usegroup)
        {
            if (!this.canReplaceNext)
                return;
            SearchResult sr = this.iterator.Current;
            if (usegroup)
                this.textBox.SelectedText = sr.Result(newpattern);
            else
                this.textBox.SelectedText = newpattern;
            this.textBox.Refresh();
        }

        public void ReplaceAll(string pattern, string newpattern, bool usegroup, bool useregex, RegexOptions opt)
        {
            this.textBox.Document.SetFindParam(pattern, useregex, opt);
            this.textBox.Document.ReplaceAll(newpattern, usegroup);
            this.textBox.Refresh();
        }
    }
}
