#!/bin/busybox sh

if [ -x /usr/local/Kobo/pickel ] ; then
  # kobo
  srcdir=/etc/images
  tdir=/mnt/onboard/etc_images
else
  # non kobo
  for srcdir in . images */images .. ../*/images '' ; do
    [ -z "$srcdir" ] && exit 1
    [ -f $srcdir/splash.raw.gz ] && break
  done
  echo "Output dir: $srcdir/ppm" 1>&2
  srcdir="$(readlink -f "$srcdir")"
  tdir="$srcdir/ppm"
fi
[ -d $tdir ] && exit 1
for p in . .. "${0%/*}" /etc/fakesh/tools "$HOME/bin" /root/bin \
         /usr/bin /bin /usr/local/bin '' ; do
  [ -z "$p" ] && exit 1
  shot=$p/screenShot-jpeg.sh
  [ -x $shot ] && break
done
shot="$(readlink -f "$shot")"
cd /

mkdir "$tdir"
fbRGB='rB=5;rP=11;gB=6;gP=5;bB=5;bP=0;bpp=16;'
for raw in "$srcdir"/*.raw.gz ; do
  [ -f "$raw" ] || continue
  [ -L "$raw" ] && continue
  b="${raw##*/}"; b="${b%.raw.gz}"
  case "$b" in
  kraken-*) fbparams='w=1024;h=758;' ;;
  dragon-*) fbparams='w=1440;h=1080;' ;;
  *) fbparams='w=800;h=600;' ;;
  esac
  "$shot" conv fmt:ppm "$tdir/$b" "fb:$fbparams$fbRGB" wait < "$raw"
done >/dev/null 2>&1 </dev/null &

exit 0
