﻿using System;
using System.Runtime.InteropServices;
using System.Windows;
using System.Windows.Interop;
using Azyobuzi.XamlIn.Installer.ViewModels;

namespace Azyobuzi.XamlIn.Installer.Views
{
    /// <summary>
    /// インストーラウィザードを表示するウィンドウ
    /// </summary>
    public partial class MainWindow : Window
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public MainWindow()
        {
            InitializeComponent();
        }

        [DllImport("USER32.DLL")]
        private static extern IntPtr GetSystemMenu(IntPtr hWnd, UInt32 bRevert);

        [DllImport("USER32.DLL")]
        private static extern bool AppendMenu(IntPtr hMenu, UInt32 uFlags, UInt32 uIDNewItem, string lpNewItem);

        private const UInt32 MF_BYCOMMAND = 0x00000000;
        private const UInt32 MF_STRING = 0x00000000;
        private const UInt32 MF_SEPARATOR = 0x00000800;
        private const int WM_SYSCOMMAND = 0x112;

        private void mainWindow_Loaded(object sender, RoutedEventArgs e)
        {
            var source = HwndSource.FromVisual(this) as HwndSource;

            IntPtr hMenu = GetSystemMenu(source.Handle, 0);

            AppendMenu(hMenu, MF_SEPARATOR, 0, string.Empty);
            AppendMenu(hMenu, MF_STRING, MF_BYCOMMAND, "&About Installation...");

            source.AddHook((IntPtr hwnd, int msg, IntPtr wParam, IntPtr lParam, ref bool handled) =>
            {
                if (msg == WM_SYSCOMMAND && ((uint)wParam) == MF_BYCOMMAND)
                {
                    MessageBox.Show(
                        "XamlIn\n\nproduct by @azyobuzin",
                        "About Installation",
                        MessageBoxButton.OK,
                        MessageBoxImage.Information);
                    handled = true;
                }
                return IntPtr.Zero;
            });

            (this.DataContext as MainWindowViewModel).RaisedMessage += this.ReceiveMessage;
        }

        private void ReceiveMessage(object sender, RaisedMessageEventArgs e)
        {
            switch (e.MessageKey)
            {
                case "Cancel":
                    this.Close();
                    break;
            }
        }
    }
}
