﻿using System;

namespace Azyobuzi.XamlIn.Installer.ViewModels
{
    /// <summary>
    /// 内部で使用するViewModelのベース
    /// </summary>
    public abstract class ViewModelBase : NotifyObject
    {
        /// <summary>
        /// メッセージが送信されたときに発生します。
        /// </summary>
        public event EventHandler<RaisedMessageEventArgs> RaisedMessage;

        /// <summary>
        /// メッセージを送信します。
        /// </summary>
        /// <param name="e"><see cref="RaisedMessageEventArgs"/>のインスタンス</param>
        protected void RaiseMessage(RaisedMessageEventArgs e)
        {
            if (RaisedMessage != null)
                RaisedMessage(this, e);
        }
    }

    /// <summary>
    /// 内部で使用するメッセージの内容
    /// </summary>
    public class RaisedMessageEventArgs : EventArgs
    {
        /// <summary>
        /// メッセージの識別子
        /// </summary>
        public string MessageKey { set; get; }

        /// <summary>
        /// メッセージとして渡すオブジェクト
        /// </summary>
        public object Object { set; get; }
    }
}
