﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Input;
using Azyobuzi.XamlIn.Installer.Models;

namespace Azyobuzi.XamlIn.Installer.ViewModels
{
    /// <summary>
    /// <see cref="Views.MainWindow"/>のViewModel。のはずなのにコントロールもってたりModelの役もしたり。
    /// </summary>
    public class MainWindowViewModel : ViewModelBase
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="project">インストーラの情報を格納している<see cref="Models.XamlIn"/></param>
        public MainWindowViewModel(Models.XamlIn project)
        {
            this.Project = project;
        }

        /// <summary>
        /// インストーラの情報
        /// </summary>
        public Models.XamlIn Project { private set; get; }

        private bool isInstalling = false;
        /// <summary>
        /// インストール作業中かどうか
        /// </summary>
        public bool IsInstalling
        {
            set
            {
                if (isInstalling != value)
                {
                    isInstalling = value;
                    RaisePropertyChanged(() => this.IsInstalling);
                }
            }
            get
            {
                return isInstalling;
            }
        }

        private ICommand cancelCommand;
        /// <summary>
        /// インストーラを終了させるコマンド
        /// </summary>
        public ICommand CancelCommand
        {
            get
            {
                if (this.cancelCommand == null)
                    this.cancelCommand = new DelegateCommand(
                        () => this.RaiseMessage(new RaisedMessageEventArgs { MessageKey = "Cancel" }),
                        () => !this.IsInstalling
                    );
                return this.cancelCommand;
            }
        }
    }
}
