﻿using System;
using System.ComponentModel;
using System.Linq.Expressions;

namespace Azyobuzi.XamlIn.Installer
{
    /// <summary>
    /// <see cref="INotifyPropertyChanged"/>を実装したオブジェクト。内部で使用されます。
    /// </summary>
    public abstract class NotifyObject : INotifyPropertyChanged
    {
        /// <summary>
        /// プロパティ値が変更されたときに発生します。
        /// </summary>
        public event PropertyChangedEventHandler PropertyChanged;

        /// <summary>
        /// PropertyChangedを発生させます。
        /// </summary>
        /// <param name="propertyName">プロパティ名</param>
        protected virtual void RaisePropertyChanged(string propertyName)
        {
            if (this.PropertyChanged != null)
                this.PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
        }

        /// <summary>
        /// PropertyChangedを発生させます。
        /// </summary>
        /// <typeparam name="T">プロパティの型</typeparam>
        /// <param name="property">通知するプロパティを<c>() => PropertyName</c>の様に指定します。</param>
        protected virtual void RaisePropertyChanged<T>(Expression<Func<T>> property)
        {
            this.RaisePropertyChanged(((MemberExpression)property.Body).Member.Name);
        }
    }
}
