﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Azyobuzi.XamlIn.Installer.Models
{
    /// <summary>
    /// インストーラの設定
    /// </summary>
    public class XamlIn
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public XamlIn()
        {
            WindowWidth = 500d;
            WindowHeight = 380d;
        }

        /// <summary>
        /// ソースファイルのコレクション。複数ファイルで設定可能。
        /// </summary>
        public FileCollection Files { set; get; }

        /// <summary>
        /// インストーラのウィンドウの幅。初期値は500。
        /// </summary>
        public double WindowWidth { set; get; }

        /// <summary>
        /// インストーラのウィンドウの高さ。初期値は380。
        /// </summary>
        public double WindowHeight { set; get; }

        /// <summary>
        /// 製品名。アンインストール情報として使用されます。
        /// </summary>
        public string ProductName { set; get; }

        /// <summary>
        /// 識別子。アンインストール情報を格納するレジストリのキーとして使用されます。
        /// 他の製品と被らないようにしてください。
        /// </summary>
        public string Id { set; get; }

        /// <summary>
        /// 製品のバージョン
        /// </summary>
        public Version ProductVersion { set; get; }

        /// <summary>
        /// ダイアログのリスト。複数ファイルで設定可能。
        /// </summary>
        public DialogPageCollection DialogPages { set; get; }
    }
}
