﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace Azyobuzi.HatenaDiaryClient.Models.Hatena
{
    public class HatenaFotolife
    {
        public string UserName { set; get; }
        public string Password { set; get; }

        public FotolifeEntry Upload(string title, string fileName, string folder = null)
        {
            string mimeType;
            #region MIME Type判断
            switch (Path.GetExtension(fileName).TrimStart('.').ToLower())
            {
                case "jpg":
                case "jpeg":
                    mimeType = "image/jpeg";
                    break;
                case "gif":
                    mimeType = "image/gif";
                    break;
                case "png":
                    mimeType = "image/png";
                    break;
                case "bmp":
                    mimeType = "image/x-bmp";
                    break;
                //case "mov":
                //    mimeType = "video/quicktime";
                //    break;
                //case "mpg":
                //case "mpeg":
                //case "m1v":
                //    mimeType = "video/mpeg";
                //    break;
                //case "wmv":
                //    mimeType = "video/x-ms-wmv";
                //    break;
                //case "avi":
                //    mimeType = "video/avi";
                //    break;
                //case "flv":
                //    mimeType = "video/x-flv";
                //    break;
                //case "3gp":
                //case "3gpp":
                //    mimeType = "video/3gpp";
                //    break;
                //case "3g2":
                //    mimeType = "video/3gpp2";
                //    break;
                default:
                    throw new ArgumentException("対応してないファイルです。");
            } 
            #endregion

            var entry = new XElement(XmlNamespaces.Atom02Spec + "entry",
                new XElement(XmlNamespaces.Atom02Spec + "title", title),
                new XElement(XmlNamespaces.Atom02Spec + "content",
                    new XAttribute("mode", "base64"),
                    new XAttribute("type", mimeType),
                    Convert.ToBase64String(File.ReadAllBytes(fileName)))
            );

            if (!string.IsNullOrEmpty(folder))
                entry.Add(new XElement(XmlNamespaces.DublinCore + "subject", folder));
                        
            var reXml = WsseAtomConnection.Post(
                "http://f.hatena.ne.jp/atom/post",
                new XDocument(entry),
                Encoding.GetEncoding("shift_jis"),
                this.UserName,
                this.Password);
            return new FotolifeEntry(reXml.Root);
        }

        public FotolifeEntry GetEntry(string id)
        {
            return new FotolifeEntry(
                WsseAtomConnection.Get(
                    "http://f.hatena.ne.jp/atom/edit/" + id,
                    Encoding.UTF8,
                    this.UserName,
                    this.Password
                )
                .Root
            );
        }

        public void EditEntry(string id, string newTitle)
        {
            WsseAtomConnection.Put(
                "http://f.hatena.ne.jp/atom/edit/" + id,
                null,
                Encoding.GetEncoding("shift_jis").GetBytes(
                    new XDocument(
                        new XElement(XmlNamespaces.Atom02Spec + "entry",
                            new XElement(XmlNamespaces.Atom02Spec + "title", newTitle)
                        )
                    )
                    .ToString()
                ),
                null,
                this.UserName,
                this.Password);
        }

        public void DeleteEntry(string id)
        {
            WsseAtomConnection.Delete(
                "http://f.hatena.ne.jp/atom/edit/" + id,
                this.UserName,
                this.Password);
        }

        public IEnumerable<FotolifeEntry> GetEntrys(int page = 1)
        {
            return WsseAtomConnection.Get(
                "http://f.hatena.ne.jp/atom/feed?page=" + page.ToString(),
                Encoding.UTF8,
                this.UserName,
                this.Password
            )
            .Root
            .Elements(XmlNamespaces.Atom02Spec + "entry")
            .Select(_ => new FotolifeEntry(_));
        }
    }
}
