﻿using System.Runtime.Serialization.Json;
using System.Text;
using System.Xml;
using System.Xml.Linq;
using LinqToTwitter;

namespace Azyobuzi.UserStreamEx
{
    public static class AddToLinqToTwitter
    {
        public static INotStartedUserStream UserStreamEx(this TwitterContext twCtx)
        {
            return new UserStream(twCtx.AuthorizedClient);
        }
    }

    internal static class MyExtensions
    {
        public static XElement JsonToXml(this string json)
        {
            using (var reader = JsonReaderWriterFactory.CreateJsonReader(Encoding.UTF8.GetBytes(json), XmlDictionaryReaderQuotas.Max))
            {
                return XElement.Load(reader);
            }
        }
    }
}
