
OUTPUT_FORMAT("elf32-bfin","elf32-bfin","elf32-bfin")
OUTPUT_ARCH(bfin)


MEMORY
  {
    MEM_SDRAM (XW)    : ORIGIN = 0x00000000, LENGTH = 128M
    MEM_ASYNC_0 (XW)  : ORIGIN = 0x20000000, LENGTH = 1M
    MEM_ASYNC_1 (XW)  : ORIGIN = 0x20100000, LENGTH = 1M
    MEM_ASYNC_2 (XW)  : ORIGIN = 0x20200000, LENGTH = 1M
    MEM_ASYNC_3 (XW)  : ORIGIN = 0x20300000, LENGTH = 1M

    MEM_L1_DATA_A (W!X)  : ORIGIN = 0xff804000, LENGTH = 16K
    MEM_L1_CODE (XR)     : ORIGIN = 0xffa08000, LENGTH = 48K
    MEM_L1_SCRATCH (W!X) : ORIGIN = 0xffb00000, LENGTH = 4K
    
    MEM_L2              : ORIGIN = 0xffe00000, LENGTH = 0   /* DUMMY */
    
    MEM_SYSMMR (W!X)  : ORIGIN = 0xffc00000, LENGTH = 2M
    MEM_COREMMR (W!X) : ORIGIN = 0xffe00000, LENGTH = 2M
  }
SECTIONS
{
    
/* ADSP-BF533依存のSYSTEM MMR */ 
    .bss.sysmmr (NOLOAD) : {                    *.o(PWRMGMT)}> MEM_SYSMMR
    .bss.sysmmr (NOLOAD) : { . = ALIGN(0x0100); *.o(SYSRST)} > MEM_SYSMMR
    .bss.sysmmr (NOLOAD) : { . = ALIGN(0x0100); *.o(WDOG)}   > MEM_SYSMMR
    .bss.sysmmr (NOLOAD) : { . = ALIGN(0x0100); *.o(RTC)}    > MEM_SYSMMR
    .bss.sysmmr (NOLOAD) : { . = ALIGN(0x0100); *.o(UART)}   > MEM_SYSMMR
    .bss.sysmmr (NOLOAD) : { . = ALIGN(0x0100); *.o(SPI)}    > MEM_SYSMMR
    .bss.sysmmr (NOLOAD) : { . = ALIGN(0x0100); *.o(TIMER)}  > MEM_SYSMMR
    .bss.sysmmr (NOLOAD) : { . = ALIGN(0x0040); *.o(TMRCTL)} > MEM_SYSMMR
    .bss.sysmmr (NOLOAD) : { . = ALIGN(0x0100); *.o(FLAG)}   > MEM_SYSMMR
    .bss.sysmmr (NOLOAD) : { . = ALIGN(0x0100); *.o(SPORT0)} > MEM_SYSMMR
    .bss.sysmmr (NOLOAD) : { . = ALIGN(0x0100); *.o(SPORT1)} > MEM_SYSMMR
    .bss.sysmmr (NOLOAD) : { . = ALIGN(0x0100); *.o(EBIU)} > MEM_SYSMMR
    .bss.sysmmr (NOLOAD) : { . = ALIGN(0x0100); *.o(DMATC)} > MEM_SYSMMR
    .bss.sysmmr (NOLOAD) : { . = ALIGN(0x0100); *.o(DMA)} > MEM_SYSMMR
    .bss.sysmmr (NOLOAD) : { . = ALIGN(0x1000); *.o(PPI)} > MEM_SYSMMR

/* Blackfin 共有のCORE MMR */    
    .bss.coremmr (NOLOAD) : {                    *.o(DMEMCTL)}> MEM_COREMMR
    .bss.coremmr (NOLOAD) : { . = ALIGN(0x0100); *.o(DCPLBA)}> MEM_COREMMR
    .bss.coremmr (NOLOAD) : { . = ALIGN(0x0100); *.o(DCPLBD)}> MEM_COREMMR
    .bss.coremmr (NOLOAD) : { . = ALIGN(0x0100); *.o(DTESTC)}> MEM_COREMMR
    .bss.coremmr (NOLOAD) : { . = ALIGN(0x0100); *.o(DTESTD)}> MEM_COREMMR
    .bss.coremmr (NOLOAD) : { . = ALIGN(0x1000); *.o(IMEMCTL)}> MEM_COREMMR
    .bss.coremmr (NOLOAD) : { . = ALIGN(0x0100); *.o(ICPLBA)}> MEM_COREMMR
    .bss.coremmr (NOLOAD) : { . = ALIGN(0x0100); *.o(ICPLBD)}> MEM_COREMMR
    .bss.coremmr (NOLOAD) : { . = ALIGN(0x0100); *.o(ITESTC)}> MEM_COREMMR
    .bss.coremmr (NOLOAD) : { . = ALIGN(0x0100); *.o(ITESTD)}> MEM_COREMMR
    .bss.coremmr (NOLOAD) : { . = ALIGN(0x1000); *.o(EVT)}> MEM_COREMMR
    .bss.coremmr (NOLOAD) : { . = ALIGN(0x0100); *.o(CEC)}> MEM_COREMMR
    .bss.coremmr (NOLOAD) : { . = ALIGN(0x1000); *.o(CTMR)}> MEM_COREMMR
    .bss.coremmr (NOLOAD) : { . = ALIGN(0x1000)+0x1000; *.o(DBG)}> MEM_COREMMR  /* 1000飛ばす */
    .bss.coremmr (NOLOAD) : { . = ALIGN(0x1000); *.o(TBCTL)}> MEM_COREMMR
    .bss.coremmr (NOLOAD) : { . = ALIGN(0x0100); *.o(TBUF)}> MEM_COREMMR
    .bss.coremmr (NOLOAD) : { . = ALIGN(0x1000); *.o(WPICTL)}> MEM_COREMMR
    .bss.coremmr (NOLOAD) : { . = ALIGN(0x0040); *.o(WPIADDR)}> MEM_COREMMR
    .bss.coremmr (NOLOAD) : { . = ALIGN(0x0040); *.o(WPICNT)}> MEM_COREMMR
    .bss.coremmr (NOLOAD) : { . = ALIGN(0x0100); *.o(WPDCTL)}> MEM_COREMMR
    .bss.coremmr (NOLOAD) : { . = ALIGN(0x0040); *.o(WPDADDR)}> MEM_COREMMR
    .bss.coremmr (NOLOAD) : { . = ALIGN(0x0040); *.o(WPDCNT)}> MEM_COREMMR
    .bss.coremmr (NOLOAD) : { . = ALIGN(0x0100); *.o(WPSTAT)}> MEM_COREMMR
    .bss.coremmr (NOLOAD) : { . = ALIGN(0x1000); *.o(PFCTL)}> MEM_COREMMR
    .bss.coremmr (NOLOAD) : { . = ALIGN(0x0100); *.o(PFCNT)}> MEM_COREMMR
    
    .comment        0 : { *(.comment) }
    .debug          0 : { *(.debug) }
    .line           0 : { *(.line) }
    .debug_srcinfo  0 : { *(.debug_srcinfo) }
    .debug_sfnames  0 : { *(.debug_sfnames) }
    .debug_aranges  0 : { *(.debug_aranges) }
    .debug_pubnames 0 : { *(.debug_pubnames) }
}
