#include	"dstatus.h"
#include	"config.h"

extern	void	handler(int sig);
void	status_send_pttoff (struct ModuleTable *pnt);


#define CRCPOLY2 0xEDB88320

unsigned int crc32(int n, unsigned char c[])
{
	int i, j;
	unsigned int r;

	r = 0xFFFFFFFFUL;
	for (i = 0; i < n; i++) {
		r ^= c[i];
		for (j = 0; j < 8 ; j++)
			if (r & 1) r = (r >> 1) ^ CRCPOLY2;
			else       r >>= 1;
	}
	return r ^ 0xFFFFFFFF;
}


void	pselectSet(void)
{
	FD_ZERO (&fd_save);
	sigemptyset (&save_sig);
	sigaddset (&save_sig, SIGUSR1);
	sigaddset (&save_sig, SIGUSR2);
	sigaddset (&save_sig, SIGTERM);
	sigaddset (&save_sig, SIGINT);
        timeout.tv_sec = 0;
        timeout.tv_nsec = 10000000;
}
/*
void	module_delete (char FrameID[])
{
	struct ModuleTable *pnt;
	struct ModuleTable *prev;

	pnt = module_pnt;
	prev = NULL;
	while (pnt)
	{
		if (!memcmp (FrameID, pnt->FrameID, 2))
		{
			if (pnt == module_pnt)
			{
				module_pnt = pnt->f_chain;
			}
			else
			{
				prev->f_chain = pnt->f_chain;
			}
			free (pnt);
			return;
		}
		prev = pnt;
		pnt = pnt->f_chain;
	}
}
*/

void    module_pass_check (void)
{
        struct ModuleTable *pnt;
        struct ModuleTable *prev;
	struct  timeval cur_time;
	struct	timeval time_2sec;
	struct	timeval time_temp;

        pnt = module_pnt;
	gettimeofday (&cur_time, NULL);
        while (pnt)
        {
		if (pnt->recv_time.tv_sec || pnt->recv_time.tv_usec)
		{
                	time_2sec.tv_sec = 2;
                	time_2sec.tv_usec = 0;
                	timeradd (&pnt->recv_time, &time_2sec, &time_temp);
                	if (timercmp (&cur_time, &time_temp, >))
                	{
				pnt->recv_time.tv_sec = 0;
				pnt->recv_time.tv_usec = 0;
				status_send_pttoff (pnt);
                	}
		}
               	pnt = pnt->f_chain;
        }
}

struct ModuleTable *module_check (char call[])
{

	struct ModuleTable *pnt;
	time_t	atime;

	pnt = module_pnt;

	while (pnt)
	{
		if (!memcmp (call, pnt->ModuleName, 8)) return pnt;
		pnt = pnt->f_chain;
	}
	return NULL;
}


struct 	ModuleTable *module_check_ex (char FrameID[])
{
	struct ModuleTable *pnt;

	pnt = module_pnt;
	while (pnt)
	{
		if (!memcmp (FrameID, pnt->FrameID, 2)) return  pnt;
		pnt = pnt->f_chain;
	}
	return NULL;
}


struct ModuleTable *module_request_check (char id[])
{

        struct ModuleTable *pnt;

        pnt = module_pnt;

        while (pnt)
        {
                if (!memcmp (id, pnt->request_id, 2)) return pnt;
                pnt = pnt->f_chain;
        }
        return NULL;
}
