/** 
 * @file
 * @brief System C^[tF[X̎NX
 *
 * @author S.F.
 * @version $Id:
 * OHSystemC^[tF[XʂăANZX邱ƂŁAOSL
 * ׂĎNX̒ɕ߂܂B
 * 2001/3/13 Ղ[񂳂̃CuQlWindowsbZ[W@ύX
 * (QƁEp̋͂Ղ[񂳂(http://puyon.pns.to/)肢Ă܂B)
 * Copyright (C) 2000-2002 Satoshi Fujiwara. All Rights Reserved. */

#pragma warning( disable : 4786 )	//STĽxO
#include "sfdebug.h"


// SYSTEM INCLUDES
//
//#define INITGUID

#define WIN32_LEAN_AND_MEAN

#include "math.h"
#include <list>
#include <queue>
#include <memory>
#include <map>
#include <iostream>
#include <strstream>

#include "windows.h"
#include "windowsx.h"
#include "d3d9.h"
#include "d3dx9.h"
//#include "dmusici.h"
#include "mmsystem.h"
#include "dinput.h"
#include "dxerr8sf.h"

// PROJECT INCLUDES
//

#include "exception.h"
#include "resource.h"
#include "System.h"
#include "Console.h"
#include "Obj.h"
#include "singleton.h"
#include "AbstractSprite.h"
#include "ConsoleImpl.h"	
#include "SoundImpl.h"
#include "InputImpl.h"
#include "Main.h"
#include "SystemWin32.h"
#include "SystemImpl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// [[Nop

// LOCAL INCLUDES
//

// FORWARD REFERENCES
//

// namespace
namespace sf {
	namespace system {
// constant

System * const instance(void)
{ 
	return SystemImpl::instance();
}// getInstance()

const wchar_t SystemImpl::smAppName[] = L"Shooting Game!";	// constant

// VOgp^[[܂邽߂̃}N
IMPLEMENT_SINGLETON(SystemImpl,SystemImpl);

// RXgN^ -------------------------------------------------------------
SystemImpl::SystemImpl()
{
	// ̏
	mIsWindowActive = false;
	mpConsole = NULL;
	mpSound = NULL;
	mpInput = NULL;
	mpMain = NULL;
	mTimerInterval = TIMER_INTERVAL;
	mbWindowed = false;
	mTimerElapsed = 0;
	mTimerValue = timeGetTime();
	mTimerBefore = mTimerValue;

	mFrameStep = (float)(TIMER_INTERVAL) / 32.0f;
	mFramePerSec = 1000.0f / (float)TIMER_INTERVAL;

	// COM ̏
	CoInitialize(NULL);

}// SystemImpl()


// fXgN^ ---------------------------------------------------------------
SystemImpl::~SystemImpl()
{
	OutputDebugString("~SystemImpl()");
	uninitialize();
	CoUninitialize();
}// ~SystemImpl()

/*! Is
@JȂ΂ȂȂ|C^ACOMIuWFNgȂǂׂ̏͂Ăōs܂ */
void SystemImpl::uninitialize(void)
{
	// ConsoleC^[tF[X̊J
	if(mpConsole){
		delete mpConsole;
		mpConsole = NULL;
	}

	// MainC^[tF[X̊J
	// auto_ptrȂ̂delete͂Ȃ
	if(mpMain){
	
		mpMain = NULL;
	}

	// SoundC^[tF[X̊J
	if(mpSound)
	{
		delete mpSound;
		mpSound = NULL;
	}

	// InputC^[tF[X̊J
	if(mpInput)
	{
		delete mpInput;
		mpInput = NULL;
	}
	
	// WindowMessageMap̊J
	WindowMessageMap::iterator it;
	for(it = mWindowMessageMap.begin();it != mWindowMessageMap.end();++it)
	{
		if((*it).second){
			delete ((*it).second);
		}
	}
	mWindowMessageMap.erase(mWindowMessageMap.begin(),mWindowMessageMap.end());

}

// WindowsC --------------------------------------------------------------
// Windows
int SystemImpl::winMain (const HINSTANCE hThisInstance, const HINSTANCE hPrevInstance,
					const LPSTR lpszCmdParam, const int nCmdShow)
{
	MSG msg;

	//	HWND mHWNDMain;
	// fobOp


	setupMessageMap();

	//EBhENX̓o^//
	
	//{eH̃EChE쐬B
	WNDCLASSW    wndclass;
    
	wndclass.style         = CS_DBLCLKS;   
	wndclass.lpfnWndProc   = &wndFunc;	 // window function
	wndclass.cbClsExtra    = 0;			 // no extra count of bytes
	wndclass.cbWndExtra    = 0;			 // no extra count of bytes
	wndclass.hInstance     = hThisInstance; // this instance
	wndclass.hIcon         = LoadIcon (hThisInstance,  MAKEINTRESOURCE(IDI_ICON1));
	wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW);
	wndclass.hbrBackground = (HBRUSH)GetStockObject (WHITE_BRUSH);
	wndclass.lpszMenuName  = NULL;		//j[Ȃ̃EChE
	//MAKEINTRESOURCE (IDR_MENU1);;
    wndclass.lpszClassName = smAppName;	// Av̖O
   
	RegisterClassW (&wndclass);
//WS_EX_TOPMOST
	//@̕ӂ͂قƂConsoleNX̎NXɓꂽ̂...	
    mHWNDMain = CreateWindowExW (
		WS_EX_APPWINDOW,				// window style
		smAppName,					// window class name
		smAppName,	// window caption
		WS_VISIBLE | WS_POPUP | WS_SYSMENU, // window style
		CW_USEDEFAULT,			// initial x position
		CW_USEDEFAULT,         // initial y position
		console::screen::WIDTH,                   // initial x size
		console::screen::HEIGHT,                   // initial y size
		NULL,                  // parent window handle
		NULL,                  // window menu handle
		hThisInstance,         // program instance handle
		NULL);                 // creation parameters

    // Ȃꍇ I
	if (!mHWNDMain)
		return FALSE;

	ShowWindow (mHWNDMain, nCmdShow);
	UpdateWindow (mHWNDMain);
	SetFocus(mHWNDMain);

	

#ifdef _DEBUG
	mbWindowed = true;
#endif
	try {
		// ʃIuWFNg𐶐 
		mpConsole = new console::ConsoleImpl(mHWNDMain,mbWindowed);
		mpConsole->initialize();
		
		// TEhIuWFNg𐶐
		mpSound = new sound::SoundImpl();
		mpSound->initialize();
	
		// CvbgfoCXIuWFNg̐
		mpInput = new input::InputImpl(mHWNDMain);
		mpInput->initialize();

		//ʂ܂...	
		Sleep(3000);

		// CIuWFNg̐
//		mpMain = ::sf::application::Maininstance();
		mpMain->initialize();

	} catch (FatalErrorException& e) {
		errorTerminate(e.getDefaultMessage());
		return FALSE;
	} catch (RecoverbleErrorException& e) {
		using namespace sf::system;
		switch(e.errorType()){
		case Exception::SCENE_IS_EMPTY:
			return TRUE;
			break;
		default:
			throw;
		}
	} catch (...) {
		throw;
	}
	
	// ^C}[̕\鏈
	initTimer();
	
//	HANDLE hProcess;
//	hProcess = GetCurrentProcess();
//	SetPriorityClass(hProcess,CRITICAL_PRIORITY_CLASS);

	// bZ[W[v
	// Ƃ̕ӂAʂWindowsAvƈႤB
	//  WindowbZ[WȂꍇ́ACĂяoB
	while(1)
	{
		if (PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE))
		{
			if (!GetMessage( &msg, NULL, 0, 0))
			{
				return msg.wParam;
			}
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else        
		{
			if(isWindowActive())
			{
				try{
					wait();
					// ʍXV 
					mpConsole->update();
					// ̓foCX̃XibvVbg擾
					mpInput->update();
					mpSound->update();
					
					mpMain->run();
//#ifdef _DEBUG
					mpConsole->print(0,console::viewport::X + 8,0.0f,0.0f,1.0f,0xffffffff,"%d ms ",mTimerElapsed);
//#endif
					// 
					mTimerElapsed = timeGetTime() - mTimerValue;
					} catch (FatalErrorException e) {
						delete mpConsole;
						mpConsole = NULL;
						errorTerminate(e.getDefaultMessage());
						windowActivate(false);
					} catch (RecoverbleErrorException e) {
						PostMessage( mHWNDMain, WM_CLOSE, 0, 0L );
						windowActivate(false);
					} catch (...) {
						throw;
					}
			}
		} 
	}
}

// Window Function ------------------------------------------------------------
//	قƂɎ̂킩͈͂̍Œ̃CxgĂȂ̂ŊȒPłB
LRESULT CALLBACK SystemImpl::wndFunc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	// iSystemC^[tF[X̂܂܂ł́AۃNX̃vCx[g\bh
	// ĂяoȂ̂ŁA_Ci~bNLXg
	
	SystemImpl *pSysSystemImpl = dynamic_cast<SystemImpl *>(instance());
	
	if(pSysSystemImpl == NULL)
		return DefWindowProc (hwnd, message, wParam, lParam);

	WindowMessage *pmessage = pSysSystemImpl->mWindowMessageMap[message]; 

	if(pmessage)
		return pmessage->call(hwnd,wParam,lParam);
	
	// message 
	switch (message)
	{
        case WM_SYSCOMMAND:
			return pSysSystemImpl->onSysCommand(hwnd,wParam,lParam);
		// IƂ̏
		case WM_CLOSE:
			pSysSystemImpl->uninitialize();
	        DestroyWindow( hwnd );
			return 0;
	   case WM_DESTROY:
		  PostQuitMessage(0);      //terminate the application
		  return 0;
		default:
			break;
    }

	// ̑WindowsɂC 
    return DefWindowProc (hwnd, message, wParam, lParam);
}// WndFunc

// Windows̕`v --------------------------------------------------
LRESULT SystemImpl::onPaint(const HWND hwnd, const WPARAM wParam, const LPARAM lParam)
{
//   return DefWindowProc (hwnd, WM_PAINT, wParam, lParam);
	if(!mpConsole || !mpConsole->isEnabled())
		{
			PAINTSTRUCT ps;
			HDC hDC = BeginPaint (hwnd, &ps);
			std::string strMessage("");
			TextOut(hDC,0,0,strMessage.c_str(),strMessage.length());
			EndPaint(hwnd, &ps );	
		}
	ValidateRect(hwnd,NULL);		
	return 1;
}// onPaint()

// WindowANeBuAANeBȕ -----------------------------------
LRESULT SystemImpl::onActivate(const HWND hwnd, const WPARAM wParam, const LPARAM lParam)
{
	if((BOOL)wParam){
		windowActivate(true);
	} else {
		windowActivate(false);
	}
	return 0;
}


// j[I̎ -----------------------------------------------------------
LRESULT SystemImpl::onCommand(const HWND hwnd, const WPARAM wParam, const LPARAM lParam)
{
	// ݂͖
    // Let Default Window Proc handle it for us.
    return DefWindowProc (hwnd, WM_COMMAND, wParam, lParam);
} // onCommand



// TCYύXCxg ---------------------------------------------------------
LRESULT SystemImpl::onSize(const HWND hwnd,const WPARAM wParam,const LPARAM lParam)
{
	return 0;
}// onSize()

// 
LRESULT		SystemImpl::onSysCommand(const HWND hwnd, const WPARAM wParam, const LPARAM lParam)
{
       // Prevent moving/sizing and power loss in fullscreen mode
	switch( wParam )
	{
	case SC_MOVE:
	case SC_SIZE:
	case SC_MAXIMIZE:
	case SC_KEYMENU:
	case SC_MONITORPOWER:
		if(mbWindowed == false)
			return 1;
		break;
	}
	return DefWindowProc (hwnd, WM_SYSCOMMAND,wParam, lParam);
}


// ^C}[̏ -------------------------------------------------------
void SystemImpl::initTimer(void)
{
	const UINT TARGET_RESOLUTION  = 1 ;// 1-millisecond target resolution

	::TIMECAPS tc;
	UINT timer_res;

	if (timeGetDevCaps(&tc, sizeof(TIMECAPS)) == TIMERR_NOERROR) 
	{
		timer_res = min(max(tc.wPeriodMin, TARGET_RESOLUTION), tc.wPeriodMax);
		timeBeginPeriod(timer_res); 
	}
}// initTimer()

// w肵tick(ms)܂ŃEFCg ------------------------------------------------
void SystemImpl::wait(void)
{

		DWORD now = timeGetTime();
		
		DWORD rem = now % mTimerInterval;
		DWORD wait_time = (now / mTimerInterval + ((rem > 0)?1:0)) * mTimerInterval ;
//		DWORD wait_time = (mTimerValue / mTimerInterval + 1) * mTimerInterval ;

		DWORD wait_time_tick = wait_time - now;

		if(wait_time_tick > 4) 
			Sleep(wait_time_tick - 3);

		while(wait_time > timeGetTime());
		mTimerBefore = mTimerValue;
		mTimerValue = timeGetTime();

}// wait()

// G[\ăAvP[VI --------------------------------- 
void SystemImpl::errorTerminate(const wchar_t *errString)
{
	outputError(errString);
	SendMessage( mHWNDMain, WM_CLOSE, 0, 0 );
}// errorTerminate()

// G[\ -----------------------------------------------------------------
void SystemImpl::outputError(const wchar_t *errString)
{	std::wstring err_string = L"Error Occured!\r\n";
	//strncat(err_string,errString,sizeof(err_string) - strlen(err_string));
	err_string += errString;
	MessageBoxW( NULL, err_string.c_str(),
		smAppName,
		MB_TOPMOST | MB_SETFOREGROUND | MB_TASKMODAL | MB_ICONERROR | MB_OK );
}// outputError()

// bZ[W}bṽZbgAbv |||||||||||||||||||||
void SystemImpl::setupMessageMap()
{
/*	mWindowMessageMap[WM_PAINT] = new WindowMessageImpl<SystemImpl>(this,&SystemImpl::onPaint);
	mWindowMessageMap[WM_ACTIVATEAPP] = new WindowMessageImpl<SystemImpl>(this,&SystemImpl::onActivate);
	mWindowMessageMap[WM_COMMAND] = new WindowMessageImpl<SystemImpl>(this,&SystemImpl::onCommand);
//	mWindowMessageMap[WM_KEYDOWN] = new WindowMessageImpl<SystemImpl>(this,&SystemImpl::onKeyDown);
	mWindowMessageMap[WM_SIZE] = new WindowMessageImpl<SystemImpl>(this,&SystemImpl::onSize);
*/
	addWindowMessage(WM_PAINT,new WindowMessageImpl<SystemImpl>(this,&SystemImpl::onPaint));
	mWindowMessageMap[WM_ACTIVATEAPP] = new WindowMessageImpl<SystemImpl>(this,&SystemImpl::onActivate);
	mWindowMessageMap[WM_COMMAND] = new WindowMessageImpl<SystemImpl>(this,&SystemImpl::onCommand);
//	mWindowMessageMap[WM_KEYDOWN] = new WindowMessageImpl<SystemImpl>(this,&SystemImpl::onKeyDown);
	addWindowMessage(WM_SIZE,new WindowMessageImpl<SystemImpl>(this,&SystemImpl::onSize));


}//setupMessageMap()


}
}// namespace sf