/**
 * @file
 * @brief ́iL[{[hE}EXEWCXeBbNj̎ɂNXA萔`Ȃǂs.
 *
 * @author S.F.
 * @version $Id:
 *
 * Copyright (C) 2000-2002 Satoshi Fujiwara. All Rights Reserved.
 */

/// dCN[hh~}N
#if !defined(AFX_INPUTInputImpl_H__CAF65806_66F9_4CFF_89EC_66E36A0FB746__INCLUDED_)
#define AFX_INPUTInputImpl_H__CAF65806_66F9_4CFF_89EC_66E36A0FB746__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "sf.h"
#include "Input.h"
extern "C" {
namespace sf {
	namespace system {
		namespace input {

/** InputC^[tF[X̎.
 *  ͂rcj̃TvQlɂĂ܂B
 *  ƂقƂǂ̂܂܂łDDDB*/
class InputImpl : public Input  
{
	// LIFECYCLE //
public:
	/// }EXXi[Xgz^`
	typedef std::vector<input::mouse::Listener* > MouseListenerList;	
	/// L[{[hXi[Xgz^`
	typedef std::vector<input::keyboard::Listener*  > KeyboardListenerList;	
	/// RXgN^
	InputImpl();

	/** RXgN^
	 * @param hwnd EBhEnh */
	InputImpl(HWND hwnd);
	
	/// fXgN^
	virtual ~InputImpl();
	// OPERATORS //
	// OPERATIONS //
	void update(void);
	
	/// DirectInput̃R[obN 
	static 	BOOL CALLBACK 
		enumJoysticksCallback( const DIDEVICEINSTANCE* pdidInstance, VOID* pContext )
	{
		return ((InputImpl *)pContext)->enumJoysticksCallback(pdidInstance);
	};
	
	/// DirectInput̃R[obN
	static BOOL CALLBACK enumAxesCallback( const DIDEVICEOBJECTINSTANCE* pdidoi,
                                VOID* pContext )
	{ return ((InputImpl *)pContext)->enumAxesCallback(pdidoi);};
	
	/** }EX{^ꂽ.
	 * SystemImpl::wndFunc()WM_LBUTTONDOWN󂯎Amouse::Listenerɒʒm܂B
	 * @param hwnd EBhEnh 
	 * @param wParam WPARAM 
	 * @param lParam LPARAM */
	LRESULT		onLButtonDown(const HWND hwnd, const WPARAM wParam, const LPARAM lParam);
	
	/** }EX{^_uNbNꂽ.
	 * SystemImpl::wndFunc()WM_LBUTTONDBLCLK󂯎Amouse::Listenerɒʒm܂B
 	 * @param hwnd EBhEnh 
	 * @param wParam WPARAM 
	 * @param lParam LPARAM */
	LRESULT     onLButtonDoubleClick(const HWND hwnd, const WPARAM wParam, const LPARAM lParam);
	
	/** }EX{^ꂽ.
	 * SystemImpl::wndFunc()WM_LBUTTONUP󂯎Amouse::Listenerɒʒm܂B
	 * @param hwnd EBhEnh 
	 * @param wParam WPARAM 
	 * @param lParam LPARAM */
	LRESULT		onLButtonUp(const HWND hwnd, const WPARAM wParam, const LPARAM lParam);

	/** E}EX{^_uNbNꂽ.
	 * SystemImpl::wndFunc()WM_RBUTTONDBLCLK󂯎Amouse::Listenerɒʒm܂B
	 * @param hwnd EBhEnh 
	 * @param wParam WPARAM 
	 * @param lParam LPARAM */
	LRESULT     onRButtonDoubleClick(const HWND hwnd, const WPARAM wParam, const LPARAM lParam);
	
	/** E}EX{^ꂽ.
	 * SystemImpl::wndFunc()WM_RBUTTONDOWN󂯎Amouse::Listenerɒʒm܂B
	 * @param hwnd EBhEnh 
	 * @param wParam WPARAM 
	 * @param lParam LPARAM */
	LRESULT		onRButtonDown(const HWND hwnd, const WPARAM wParam, const LPARAM lParam);
	
	/** E}EX{^ꂽ.
	 * SystemImpl::wndFunc()WM_RBUTTONUP󂯎Amouse::Listenerɒʒm܂B
	 * @param hwnd EBhEnh 
	 * @param wParam WPARAM 
	 * @param lParam LPARAM */
	LRESULT		onRButtonUp(const HWND hwnd, const WPARAM wParam, const LPARAM lParam);
	
	/** }EXJ[\.
	 * SystemImpl::wndFunc()WM_MOUSEMOVE󂯎Amouse::Listenerɒʒm܂B
	 * @param hwnd EBhEnh 
	 * @param wParam WPARAM 
	 * @param lParam LPARAM */
	LRESULT		onMouseMove(const HWND hwnd, const WPARAM wParam, const LPARAM lParam);

	/** }EXzC[ω.
	 * SystemImpl::wndFunc()WM_MOUSEWHEEL󂯎Amouse::Listenerɒʒm܂B
	 * @param hwnd EBhEnh 
	 * @param wParam WPARAM 
	 * @param lParam LPARAM */
	LRESULT		onMouseWheel(const HWND hwnd, const WPARAM wParam, const LPARAM lParam);

	/** WM_ONSETCURSOR󂯎.
	 * SystemImpl::wndFunc()WM_ONSETCURSOR󂯎܂B
	 * ̃VXeł́A}EXJ[\E\̃Rg[̂߁ÃbZ[W󂯎Ă܂B
	 * @param hwnd EBhEnh 
	 * @param wParam WPARAM 
	 * @param lParam LPARAM 
	 * @note WM_SETCURSOR CxǵA}EX͂Lv`ꂸAEBhEŃJ[\ړƂɔ郁bZ[WłB*/
	LRESULT		onSetCursor(const HWND hwnd, const WPARAM wParam, const LPARAM lParam);

	/** }EXXi[̃\bhĂяo.
	 * EBhEbZ[W󂯎mouse::Listener̊e\bhĂяoƂȗ܂B
	 * @param hwnd EBhEnh 
	 * @param wParam WPARAM 
	 * @param lParam LPARAM 
	 * @param pMethod mouse::Listener̃\bh̃|C^@*/
	LRESULT		callMouseListenerMethod(const HWND hwnd, const WPARAM wParam, const LPARAM lParam,void(input::mouse::Listener::*pMethod)(const int,const int,const DWORD));
	
	// L[{[hbZ[Wnh
	/** L[{[hꂽ.
	 * system::SystemImpl::wndFunc()WM_KEYDOWN󂯎Akeyboard::Listenerɒʒm܂B
	 * @param hwnd EBhEnh 
	 * @param wParam WPARAM 
	 * @param lParam LPARAM */
	LRESULT		onKeyDown(const HWND hwnd, const WPARAM wParam, const LPARAM lParam);
	
	/** L[{[hꂽ.
	 * system::SystemImpl::wndFunc()WM_KEYUP󂯎Akeyboard::Listenerɒʒm܂B
	 * @param hwnd EBhEnh 
	 * @param wParam WPARAM 
	 * @param lParam LPARAM */
	LRESULT		onKeyUp(const HWND hwnd, const WPARAM wParam, const LPARAM lParam);

	/** EBhEbZ[W}bv֓o^s. 
	 * [eBOEBhEbZ[Wo^܂B*/
	void		addWindowMessageMap();

	/** MouseListener̒ǉs. 
	 * mouse::ListenerInputImpl::mMouseListenerQɒǉ܂B
	 * @param pListener mouse::Listener̃|C^ */
	void addMouseListener(input::mouse::Listener * const pListener){
			mMouseListenerQ.push_back(pListener);				
	};
	

	/** MouseListener̍폜s 
	 * @param pListener mouse::Listener̃|C^*/
	void removeMouseListener(input::mouse::Listener * const pListener){
		MouseListenerList::iterator it;
		for(it = mMouseListenerList.begin();
			it != mMouseListenerList.end();it++){
			if(pListener == *it){
//				mMouseListenerList.erase(it);
				*it = NULL;
				break;
			}
		}

		for(it = mMouseListenerQ.begin();
			it != mMouseListenerQ.end();it++){
			if(pListener == *it){
				*it = NULL;
				return;
			}
		}
	};

	/** KeyboardListener̒ǉs 
	 * @param pListener keyboard::Listener ̃|C^ */
	void addKeyboardListener(input::keyboard::Listener * const pListener){
			mKeyboardListenerQ.push_back(pListener);				
	};
	

	/** KeyboardListener̍폜s
	 * @param pListener keyboard::Listener̃|C^ */
	void removeKeyboardListener(input::keyboard::Listener * const pListener){
		KeyboardListenerList::iterator it;
		for(it = mKeyboardListenerList.begin();
			it != mKeyboardListenerList.end();it++){
			if(pListener == *it){
//				mKeyboardListenerList.erase(it);
				*it = NULL;
				break;
			}
		}

		for(it = mKeyboardListenerQ.begin();
			it != mKeyboardListenerQ.end();it++){
			if(pListener == *it){
				*it = NULL;
				return;
			}
		}
	};

	// ACCESS //
	const bool left(const bool bTrig = false) const 
		{ if(!bTrig) return mbLeft; else return ((mbLeft ^ mbBeforeLeft) & mbLeft) ;};
	const bool right(const bool bTrig = false) const 
		{ if(!bTrig) return mbRight; else return ((mbRight ^ mbBeforeRight) & mbRight) ;};
	const bool up(const bool bTrig = false) const
		{ if(!bTrig) return mbUp; else return ((mbUp ^ mbBeforeUp) & mbUp) ;};
	const bool down(const bool bTrig = false) const
		{ if(!bTrig) return mbDown; else return ((mbDown ^ mbBeforeDown) & mbDown) ;};
	const bool buttonA(const bool bTrig = false) const
		{ if(!bTrig) return mbButtonA; else return ((mbButtonA ^ mbBeforeButtonA) & mbButtonA) ;};
	const bool buttonB(const bool bTrig = false) const
		{ if(!bTrig) return mbButtonB; else return ((mbButtonB ^ mbBeforeButtonB) & mbButtonB) ;};
	const bool buttonC(const bool bTrig = false) const
		{ if(!bTrig) return mbButtonC; else return ((mbButtonC ^ mbBeforeButtonC) & mbButtonC) ;};
	const bool buttonD(const bool bTrig = false) const 
		{ if(!bTrig) return mbButtonD; else return ((mbButtonD ^ mbBeforeButtonD) & mbButtonD) ;};
	const bool start(const bool bTrig = false) const
		{ if(!bTrig) return mbStart; else return ((mbStart ^ mbBeforeStart) & mbStart) ;};
	const bool exit(const bool bTrig = false) const 
		{ if(!bTrig) return mbExit; else return ((mbExit ^ mbBeforeExit) & mbExit) ;};
	
	void showMouseCursor(void){mbMouseCursor = true;};
	void hideMouseCursor(void){mbMouseCursor = false;};
	
	const bool mouseCursorVisibility  (void) const{return mbMouseCursor;};

	// INQUIRY //
	const bool isEnabled(void) const {return mbEnabled;};

	void initialize(void);
private:
	/** Ȉs.
	 * IɊJȂĂ͂Ȃ̂͂ŊJ܂B*/
	void uninitialize(void);
	/** WCXeBbN̏s
	 * @exception RecoverbleErrorException WCXeBbN̏Ɏsꍇ */
	void initJoystick(void);
	/** L[{[h̏s 
	 * @exception RecoverbleErrorException L[{[h̏Ɏsꍇ */
	void initKeyboard(void);

	/// DirectInput̃R[obN 
	BOOL enumJoysticksCallback(const DIDEVICEINSTANCE* pdidInstance);
	/// DirectInput̃R[obN 
	BOOL enumAxesCallback( const DIDEVICEOBJECTINSTANCE* pdidoi);
	
	
	bool mbEnabled;///< SoundC^[tF[Xݎgpǂ
	bool mbMouseCursor;///< }EXJ[\\Ă邩Ȃ
	
	LPDIRECTINPUT8		 mpDI;///< DirectInput8 C^[tF[X		   
	
	LPDIRECTINPUTDEVICE8 mpJoystick;///< WCXeBbNC^[tF[X̃|C^
	LPDIRECTINPUTDEVICE8 mpKeyboard;///< L[{[hfoCX̃|C^
	
	DIDEVCAPS				mDIJoystickDevCaps;///< foCX\
	DIJOYSTATE2				mDIJoyState;///< WCXeBbN̏
	BYTE    mDIKeys[256];   ///< DirectInput keyboard state buffer 

	HWND					mHWND;///< EBhEnh

	// }EXCxgR[obNp
	MouseListenerList mMouseListenerList;///< mouse::Listener̔z
	MouseListenerList mMouseListenerQ;///< mouse::Listener̔z(ꎞێp)

	KeyboardListenerList mKeyboardListenerList;///< keyboard::Listener̔z
	KeyboardListenerList mKeyboardListenerQ;///< keyboard::Listener̔z(ꎞێp)

	bool mbUp;///< {^
	bool mbDown;///< {^
	bool mbLeft;///< {^
	bool mbRight;///< E{^
	
	bool mbButtonA;///< {^A
	bool mbButtonB;///< {^B
	bool mbButtonC;///< {^C
	bool mbButtonD;///< {^D
	
	bool mbStart;///< START{^
	bool mbExit;///< EXIT{^

	bool mbBeforeUp;///< {^1t[Ȍ
	bool mbBeforeDown;///< {^1t[Ȍ
	bool mbBeforeLeft;///< {^1t[Ȍ
	bool mbBeforeRight;///< E{^1t[Ȍ
	
	bool mbBeforeButtonA;///< {^A1t[Ȍ
	bool mbBeforeButtonB;///< {^B1t[Ȍ
	bool mbBeforeButtonC;///< {^C1t[Ȍ
	bool mbBeforeButtonD;///< {^D1t[Ȍ

	bool mbBeforeStart;///< START{^1t[Ȍ
	bool mbBeforeExit;///< EXIT{^1t[Ȍ
};
		} // namespace input
	} // namespace system
} // namespace sf
}
#endif // !defined(AFX_INPUTInputImpl_H__CAF65806_66F9_4CFF_89EC_66E36A0FB746__INCLUDED_)
